package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.mdm.business.user.sdk.dto.UserConditionDto;
import com.biz.crm.mdm.business.user.sdk.service.UserVoService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailExceptionFile;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailExceptionVoRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionFileService;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailExceptionQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailExceptionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 异常提报vo
 * @author: rentao
 * @date: 2022/7/5 19:46
 */
@Service
@Slf4j
public class VisitPlanDetailExceptionVoServiceImpl implements VisitPlanDetailExceptionVoService {

  @Autowired private VisitPlanDetailExceptionVoRepository visitPlanDetailExceptionVoRepository;
  @Autowired private VisitPlanDetailExceptionFileService visitPlanDetailExceptionFileService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<VisitPlanDetailExceptionVo> findByConditions(Pageable pageable,
      VisitPlanDetailExceptionQueryDto dto) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    dto = ObjectUtils.defaultIfNull(dto, new VisitPlanDetailExceptionQueryDto());
    dto.setTenantCode(TenantUtils.getTenantCode());
    return this.visitPlanDetailExceptionVoRepository.findByConditions(pageable, dto);
  }

  @Override
  public VisitPlanDetailExceptionVo findById(String id) {
    if(StringUtils.isBlank(id)){
      return null;
    }
    VisitPlanDetailExceptionVo visitPlanDetailExceptionVo = visitPlanDetailExceptionVoRepository.findById(id);
    if(Objects.nonNull(visitPlanDetailExceptionVo)){
      String exceptionVoId = visitPlanDetailExceptionVo.getId();
      List<VisitPlanDetailExceptionFile> list = this.visitPlanDetailExceptionFileService
          .findByVisitPlanDetailExceptionIds(
              Collections.singletonList(exceptionVoId));
      if(!CollectionUtils.isEmpty(list)){
        List<FileVo> fileVos = (List<FileVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list, VisitPlanDetailExceptionFile.class, FileVo.class, HashSet.class, ArrayList.class);
        visitPlanDetailExceptionVo.setFileVoList(fileVos);
      }
    }
    return visitPlanDetailExceptionVo;
  }
}
