package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailVoRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanRepository;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 拜访计划明细vo实现类
 *
 * @author songjingen
 */
@Service
public class VisitPlanDetailVoServiceImpl implements VisitPlanDetailVoService {

  @Autowired
  private List<VisitPlanDetailObserver> visitPlanDetailObservers;

  @Autowired
  private VisitPlanDetailRepository visitPlanDetailRepository;

  @Autowired
  private VisitPlanDetailVoRepository visitPlanDetailVoRepository;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitPlanRepository visitPlanRepository;

  @Autowired
  private List<ClientRouteStrategy> visitPlanClientRouteStrategies;

  @Transactional
  @Override
  public void createBatchByVisitPlanDetailDto(List<VisitPlanDetailDto> visitPlanDetailDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanDetailDtos), "批量创建数据时，入参集合不能为空");
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanDetailObservers), "批量创建数据时，为查询到明细观察者实现类！");
    ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<>();
    Map<String, List<String>> map = visitPlanDetailDtos.stream().collect(Collectors.groupingBy(VisitPlanDetailDto::getVisitRouteType, Collectors.mapping(VisitPlanDetailDto::getVisitPlanCode, Collectors.toList())));
    for (VisitPlanDetailObserver visitPlanDetailObserver : visitPlanDetailObservers) {
      List<VisitPlanDetailModel> models = visitPlanDetailObserver.onRequestVisitDetailDto(map);
      visitPlanDetailModels.addAll(models);
    }
    this.createBatch(visitPlanDetailModels);
  }

  @Transactional
  @Override
  public void updateBatchByVisitPlanDetailDto(List<VisitPlanDetailDto> visitPlanDetailDtos) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanDetailDtos), "批量创建数据时，入参集合不能为空");
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanDetailObservers), "批量创建数据时，为查询到明细观察者实现类！");
    ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<>();
    Map<String, List<String>> map = visitPlanDetailDtos.stream().collect(Collectors.groupingBy(VisitPlanDetailDto::getVisitRouteType, Collectors.mapping(VisitPlanDetailDto::getVisitPlanCode, Collectors.toList())));
    for (VisitPlanDetailObserver visitPlanDetailObserver : visitPlanDetailObservers) {
      List<VisitPlanDetailModel> models = visitPlanDetailObserver.onRequestVisitDetailDto(map);
      visitPlanDetailModels.addAll(models);
    }
    this.updateBatch(visitPlanDetailModels);
  }

  @Transactional
  @Override
  public void createBatch(List<VisitPlanDetailModel> dto) {
    Validate.isTrue(!CollectionUtils.isEmpty(dto), "批量创建数据时，入参集合不能为空！");
    List<VisitPlanDetail> visitPlanDetails = (List<VisitPlanDetail>) this.nebulaToolkitService.copyCollectionByWhiteList(dto, VisitPlanDetailModel.class, VisitPlanDetail.class, HashSet.class, ArrayList.class);
    //查询用户账号map
    Set<String> planCodes = visitPlanDetails.stream().map(VisitPlanDetail::getVisitPlanCode).collect(Collectors.toSet());
    List<VisitPlan> visitPlans = this.visitPlanRepository.findByPlanCodes(planCodes);
    Map<String, String> planMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(visitPlans)) {
      planMap = visitPlans.stream().collect(Collectors.toMap(VisitPlan::getVisitPlanCode, VisitPlan::getVisitUserName));
    }
    Set<String> userNameSets = new HashSet<>();
    Set<Date> visitDateSets = new HashSet<>();
    Set<String> clientCodeSets = new HashSet<>();
    Set<String> visitStatusSets = new HashSet<>();
    for (VisitPlanDetail visitPlanDetail : visitPlanDetails) {
      this.createValidate(visitPlanDetail);
      String userName = planMap.get(visitPlanDetail.getVisitPlanCode());
      visitPlanDetail.setVisitUserName(userName);
      visitDateSets.add(visitPlanDetail.getVisitDate());
      clientCodeSets.add(visitPlanDetail.getClientCode());
      userNameSets.add(userName);
    }
    //过滤掉用户+拜访时间+客户编码可执行的计划（拜访中，未拜访）
    visitStatusSets.add(VisitStatusEnum.NOT_VISIT.getDictCode());
    visitStatusSets.add(VisitStatusEnum.IN_THE_VISIT.getDictCode());
    List<VisitPlanDetailVo> detailList = this.visitPlanDetailVoRepository.findByUserNamesAndClientCodesAndVisitDatesAndVisitStatus(userNameSets, clientCodeSets, visitDateSets, visitStatusSets);
    if (!CollectionUtils.isEmpty(detailList)) {
      Map<String, List<VisitPlanDetailVo>> listMap = detailList.stream().collect(Collectors.groupingBy(detail -> StringUtils.joinWith("_", detail.getVisitUserName(), detail.getClientCode(), DateFormatUtils.format(detail.getVisitDate(), "yyyy_MM-dd"))));
      visitPlanDetails = visitPlanDetails.stream().filter(detail -> null == listMap.get(StringUtils.joinWith("_", detail.getVisitUserName(), detail.getClientCode(), DateFormatUtils.format(detail.getVisitDate(), "yyyy_MM-dd")))).collect(Collectors.toList());
    }
    //创建计划明细
    if (CollectionUtils.isEmpty(visitPlanDetails)) {
      return;
    }
    this.buildVisitPlanDetails(visitPlanDetails);
    this.visitPlanDetailRepository.saveBatch(visitPlanDetails);
  }

  @Transactional
  @Override
  public void updateBatch(List<VisitPlanDetailModel> dto) {
    Validate.isTrue(!CollectionUtils.isEmpty(dto), "批量更新数据时，入参集合不能为空！");
    List<VisitPlanDetail> visitPlanDetails = (List<VisitPlanDetail>) this.nebulaToolkitService.copyCollectionByWhiteList(dto, VisitPlanDetailModel.class, VisitPlanDetail.class, HashSet.class, ArrayList.class);
    Set<String> visitPlanCodes = new HashSet<>();
    visitPlanDetails.stream().forEach(visitPlanDetail -> {
      this.createValidate(visitPlanDetail);
      visitPlanCodes.add(visitPlanDetail.getVisitPlanCode());
    });
    //先删除数据，后新增数据
    this.visitPlanDetailRepository.deleteByVisitPlanCodes(visitPlanCodes);
    this.createBatch(dto);
  }

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  @Override
  public Page<VisitPlanDetailVo> findByConditions(Pageable pageable, VisitPlanDetailQueryDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new VisitPlanDetailQueryDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    if (dto.getVisitDateMonth() != null) {
      dto.setVisitDateMonthStr(DateFormatUtils.format(dto.getVisitDateMonth(), "yyyy-MM"));
    }
    Page<VisitPlanDetailVo> page = this.visitPlanDetailVoRepository.findByConditions(pageable, dto);
    List<VisitPlanDetailVo> records = page.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return new Page<>();
    }
    this.buildVisitPlanDetailVos(records);
    return page;
  }


  @Override
  public List<VisitPlanDetailVo> findByConditions(VisitPlanDetailQueryDto dto) {
    if (Objects.isNull(dto)) {
      dto = new VisitPlanDetailQueryDto();
    }
    dto.setTenantCode(TenantUtils.getTenantCode());
    List<VisitPlanDetailVo> conditions = this.visitPlanDetailVoRepository.findByConditions(dto);
    this.buildVisitPlanDetailVos(conditions);
    return conditions;
  }

  /**
   * 创建验证
   *
   * @param visitPlanDetail
   */
  private void createValidate(VisitPlanDetail visitPlanDetail) {
    Validate.notNull(visitPlanDetail, "新增时，对象信息不能为空！");
    visitPlanDetail.setId(null);
    Validate.notBlank(visitPlanDetail.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notBlank(visitPlanDetail.getClientType(), "新增数据时，客户类型不能为空！");
    Validate.notNull(visitPlanDetail.getVisitDate(), "新增数据时，拜访日期不能为空！");
    Validate.notBlank(visitPlanDetail.getVisitPlanCode(), "新增数据时，拜访计划编码不能为空！");
    Validate.notBlank(visitPlanDetail.getVisitStatus(), "新增数据时，拜访状态不能为空！");
    visitPlanDetail.setVisitYearMonth(DateFormatUtils.format(visitPlanDetail.getVisitDate(), "yyyy-MM"));
  }

  /**
   * 组装VisitPlanDetailVo集合信息
   *
   * @param records
   */
  private void buildVisitPlanDetailVos(List<VisitPlanDetailVo> records) {
    //Map<clientRoute, Map<clientType, List<clientCode>>>
    Map<String, Map<String, List<String>>> clientMap = records.stream()
        .collect(
            Collectors.groupingBy(VisitPlanDetailVo::getClientRoute,
                Collectors.groupingBy(VisitPlanDetailVo::getClientType, Collectors.mapping(VisitPlanDetailVo::getClientCode, Collectors.toList())
                )));
    //判断客户维度策略
    if (CollectionUtils.isEmpty(visitPlanClientRouteStrategies)) {
      return;
    }
    List<ClientRouteInfoVo> infoVos = new ArrayList<>();
    for (ClientRouteStrategy clientRouteStrategy : visitPlanClientRouteStrategies) {
      Map<String, List<String>> listMap = clientMap.get(clientRouteStrategy.getKey());
      if (listMap != null) {
        List<ClientRouteInfoVo> terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
        List<ClientRouteInfoVo> dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
        infoVos.addAll(terminalVos);
        infoVos.addAll(dealerVos);
      }
    }
    Map<String, List<ClientRouteInfoVo>> infoVoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(infoVos)) {
      infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith("_", o.getClientRoute(), o.getClientType(), o.getClientCode())));
    }
    for (VisitPlanDetailVo visitPlanDetailVo : records) {
      String key = StringUtils.joinWith("_", visitPlanDetailVo.getClientRoute(), visitPlanDetailVo.getClientType(), visitPlanDetailVo.getClientCode());
      List<ClientRouteInfoVo> vos = infoVoHashMap.get(key);
      if (!CollectionUtils.isEmpty(vos)) {
        ClientRouteInfoVo vo = vos.get(0);
        BeanUtil.copyProperties(vo, visitPlanDetailVo);
      }
    }
  }

  /**
   * 组装VisitPlanDetail集合信息
   *
   * @param records
   */
  private void buildVisitPlanDetails(List<VisitPlanDetail> records) {
    //Map<clientRoute, Map<clientType, List<clientCode>>>
    Map<String, Map<String, List<String>>> clientMap = records.stream()
        .collect(
            Collectors.groupingBy(VisitPlanDetail::getClientRoute,
                Collectors.groupingBy(VisitPlanDetail::getClientType, Collectors.mapping(VisitPlanDetail::getClientCode, Collectors.toList())
                )));
    //判断客户维度策略
    if (CollectionUtils.isEmpty(visitPlanClientRouteStrategies)) {
      return;
    }
    List<ClientRouteInfoVo> infoVos = new ArrayList<>();
    for (ClientRouteStrategy clientRouteStrategy : visitPlanClientRouteStrategies) {
      Map<String, List<String>> listMap = clientMap.get(clientRouteStrategy.getKey());
      if (listMap != null) {
        List<ClientRouteInfoVo> terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
        List<ClientRouteInfoVo> dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
        infoVos.addAll(terminalVos);
        infoVos.addAll(dealerVos);
      }
    }
    Map<String, List<ClientRouteInfoVo>> infoVoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(infoVos)) {
      infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith("_", o.getClientRoute(), o.getClientType(), o.getClientCode())));
    }
    for (VisitPlanDetail visitPlanDetail : records) {
      String key = StringUtils.joinWith("_", visitPlanDetail.getClientRoute(), visitPlanDetail.getClientType(), visitPlanDetail.getClientCode());
      List<ClientRouteInfoVo> vos = infoVoHashMap.get(key);
      if (!CollectionUtils.isEmpty(vos)) {
        ClientRouteInfoVo vo = vos.get(0);
        BeanUtil.copyProperties(vo, visitPlanDetail);
      }
    }
  }
}
