package com.biz.crm.sfa.business.visit.plan.local.service.strategy;

import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailPerformance;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailVoRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailPerformanceService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 拜访步骤完成情况回调监听事件实现类
 *
 * @author songjingen
 * @date 2022/6/21
 */
@Component
public class ExecutePlanCallBackStrategyForVisit implements ExecutePlanCallBackStrategy {

  @Autowired
  private VisitPlanDetailPerformanceService visitPlanDetailPerformanceService;
  @Autowired
  private VisitPlanDetailRepository visitPlanDetailRepository;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private VisitPlanDetailVoRepository visitPlanDetailVoRepository;

  @Override
  public String visitType() {
    return VisitTypeEnum.VISIT.getDictCode();
  }

  @Override
  public String visitName() {
    return VisitTypeEnum.VISIT.getValue();
  }

  @Transactional
  @Override
  public void onSave(String parentCode, String dynamicKey, String dynamicFormCode) {
    Validate.notBlank(parentCode, "保存完成情况时，父级关联唯一编码（明细id）不能为空！");
    Validate.notBlank(dynamicKey, "保存完成情况时，动态key（步骤编码）不能为空！");
    Validate.notBlank(dynamicFormCode, "保存完成情况时，表单编码不能为空！");
    VisitPlanDetailPerformance helpDefensePlanDetailPerformance = new VisitPlanDetailPerformance();
    helpDefensePlanDetailPerformance.setVisitPlanDetailId(parentCode);
    helpDefensePlanDetailPerformance.setStepCode(dynamicKey);
    helpDefensePlanDetailPerformance.setFormCode(dynamicFormCode);
    this.visitPlanDetailPerformanceService.create(helpDefensePlanDetailPerformance);
  }

  @Override
  public void onUpdateExecuteStatus(Boolean completeOrNot, String parentCode) {
    Date planDateTime = new Date();
    VisitPlanDetail visitPlanDetail = this.visitPlanDetailRepository.getById(parentCode);
    if (completeOrNot) {
      visitPlanDetail.setVisitStatus(VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode());
      visitPlanDetail.setVisitEndDate(planDateTime);
    } else {
      //验证是否存在相同时间的拜访中数据
      LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
      List<VisitPlanDetail> byUserNameAndVisitDate = this.visitPlanDetailRepository.findByVisitDateAndUserName(visitPlanDetail.getVisitDate(), loginDetails.getAccount());
      List<VisitPlanDetail> planDetails = byUserNameAndVisitDate.stream().filter(detail -> detail.getVisitStatus().equals(VisitStatusEnum.IN_THE_VISIT.getDictCode())).collect(Collectors.toList());
      Validate.isTrue(CollectionUtils.isEmpty(planDetails), "存在拜访中的计划，请完成后再次拜访！");
      visitPlanDetail.setVisitStatus(VisitStatusEnum.IN_THE_VISIT.getDictCode());
      if (visitPlanDetail.getVisitEndDate() == null) {
        visitPlanDetail.setVisitStartDate(planDateTime);
      }
    }
    this.visitPlanDetailRepository.saveOrUpdate(visitPlanDetail);
  }

  @Override
  public Set<String> onFindUserNamesByNowAndExecuteStatusIn() {
    try {
      String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
      Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
      VisitPlanDetailQueryDto dto = new VisitPlanDetailQueryDto();
      dto.setTenantCode(TenantUtils.getTenantCode());
      dto.setVisitDate(nowDate);
      dto.setVisitStatus(VisitStatusEnum.IN_THE_VISIT.getDictCode());
      List<VisitPlanDetailVo> conditions = this.visitPlanDetailVoRepository.findByConditions(dto);
      if (CollectionUtils.isEmpty(conditions)) {
        return new HashSet<>(0);
      }
      return conditions.stream().map(VisitPlanDetailVo::getVisitUserName).collect(Collectors.toSet());
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return null;
  }

}
