/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailException;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailExceptionFile;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailExceptionRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionFileService;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanDetailExceptionService")
public class VisitPlanDetailExceptionServiceImpl
implements VisitPlanDetailExceptionService {
    @Autowired
    private VisitPlanDetailExceptionRepository visitPlanDetailExceptionRepository;
    @Autowired
    private VisitPlanDetailExceptionFileService visitPlanDetailExceptionFileService;
    @Autowired
    private VisitPlanDetailRepository visitPlanDetailRepository;

    @Override
    public VisitPlanDetailException findByVisitPlanDetailId(String visitPlanDetailId) {
        if (StringUtils.isBlank((CharSequence)visitPlanDetailId)) {
            return null;
        }
        List<VisitPlanDetailException> visitPlanDetailExceptions = this.visitPlanDetailExceptionRepository.findByVisitPlanDetailId(visitPlanDetailId);
        if (visitPlanDetailExceptions == null) {
            return null;
        }
        VisitPlanDetailException visitPlanDetailException = visitPlanDetailExceptions.get(0);
        List<VisitPlanDetailExceptionFile> files = this.visitPlanDetailExceptionFileService.findByVisitPlanDetailExceptionIds(Lists.newArrayList((Object[])new String[]{visitPlanDetailException.getId()}));
        visitPlanDetailException.setPictureList(files);
        return visitPlanDetailException;
    }

    @Override
    @Transactional
    public void createBatch(List<VisitPlanDetailException> exceptions) {
        Validate.isTrue((!CollectionUtils.isEmpty(exceptions) ? 1 : 0) != 0, (String)"\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        exceptions.forEach(this::createValidate);
        this.visitPlanDetailExceptionRepository.saveBatch(exceptions);
    }

    @Override
    @Transactional
    public VisitPlanDetailException create(VisitPlanDetailException visitPlanDetailException) {
        this.createValidate(visitPlanDetailException);
        this.visitPlanDetailExceptionRepository.saveOrUpdate((Object)visitPlanDetailException);
        List<VisitPlanDetailExceptionFile> pictureList = visitPlanDetailException.getPictureList();
        if (!CollectionUtils.isEmpty(pictureList)) {
            pictureList.forEach(visitPlanDetailExceptionFile -> visitPlanDetailExceptionFile.setVisitPlanDetailExceptionId(visitPlanDetailException.getId()));
            this.visitPlanDetailExceptionFileService.createBatch(pictureList);
        }
        this.visitPlanDetailRepository.updateVisitStatusById(VisitStatusEnum.EXCEPTION.getDictCode(), visitPlanDetailException.getVisitPlanDetailId());
        return visitPlanDetailException;
    }

    private void createValidate(VisitPlanDetailException visitPlanDetailException) {
        Validate.notNull((Object)((Object)visitPlanDetailException), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanDetailException.setId(null);
        Validate.notBlank((CharSequence)visitPlanDetailException.getRemark(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f02\u5e38\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanDetailException.getVisitPlanDetailId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlanDetailException> exceptions = this.visitPlanDetailExceptionRepository.findByVisitPlanDetailId(visitPlanDetailException.getVisitPlanDetailId());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(exceptions), (String)"\u5f53\u524d\u8ba1\u5212\u5df2\u63d0\u62a5\u5f02\u5e38\uff01", (Object[])new Object[0]);
    }
}

