/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailException;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionService;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanDetailService")
public class VisitPlanDetailServiceImpl
implements VisitPlanDetailService {
    @Autowired
    private VisitPlanDetailRepository visitPlanDetailRepository;
    @Autowired
    private VisitPlanDetailExceptionService visitPlanDetailExceptionService;

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.visitPlanDetailRepository.removeByIds(idList);
    }

    @Override
    public void deleteByVisitPlanCodesAndVisitStatus(Set<String> visitPlanCodes, String visitStatus) {
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanCodes) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanCodes) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.visitPlanDetailRepository.deleteByVisitPlanCodesAndVisitStatus(visitPlanCodes, visitStatus);
    }

    @Override
    public Map<String, Integer> findScheduleByUserNameAndVisitDate(String userName, Date visitDate) {
        if (StringUtils.isBlank((CharSequence)userName) || visitDate == null) {
            return new HashMap<String, Integer>(0);
        }
        List<VisitPlanDetail> totalList = this.visitPlanDetailRepository.findByVisitDateAndUserName(visitDate, userName);
        if (CollectionUtils.isEmpty(totalList)) {
            return new HashMap<String, Integer>(0);
        }
        List completedList = totalList.stream().filter(visitPlanDetail -> VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode().equals(visitPlanDetail.getVisitStatus())).collect(Collectors.toList());
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(2);
        hashMap.put("completed", CollectionUtils.isEmpty(completedList) ? 0 : completedList.size());
        hashMap.put("total", totalList.size());
        return hashMap;
    }

    @Override
    public List<VisitPlanDetail> findByVisitDateAndUserName(Date visitDate, String userName) {
        if (visitDate == null || StringUtils.isBlank((CharSequence)userName)) {
            return new ArrayList<VisitPlanDetail>(0);
        }
        return this.visitPlanDetailRepository.findByVisitDateAndUserName(visitDate, userName);
    }

    @Override
    public void deleteByVisitPlanCodes(Set<String> visitPlanCodes) {
        this.visitPlanDetailRepository.deleteByVisitPlanCodes(visitPlanCodes);
    }

    @Override
    @Transactional
    @DynamicTaskService(cornExpression="0 5 0 * * ?", taskDesc="\u62dc\u8bbf\u8ba1\u5212\u5b9a\u65f6\u4efb\u52a1")
    public void executeTask() {
        try {
            Date before = DateUtils.addDays((Date)new Date(), (int)-1);
            String beforeStr = DateFormatUtils.format((Date)before, (String)"yyyy-MM-dd");
            Date beforeDate = DateUtils.parseDate((String)beforeStr, (String[])new String[]{"yyyy-MM-dd"});
            List<VisitPlanDetail> list = this.visitPlanDetailRepository.findByVisitDateAndVisitStatus(beforeDate, VisitStatusEnum.IN_THE_VISIT.getDictCode());
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            ArrayList<VisitPlanDetailException> exceptions = new ArrayList<VisitPlanDetailException>();
            for (VisitPlanDetail visitPlanDetail : list) {
                visitPlanDetail.setVisitStatus(VisitStatusEnum.EXCEPTION.getDictCode());
                VisitPlanDetailException visitPlanDetailException = new VisitPlanDetailException();
                visitPlanDetailException.setVisitPlanDetailId(visitPlanDetail.getId());
                visitPlanDetailException.setRemark("\u8ba1\u5212\u5df2\u8fc7\u671f\uff0c\u66f4\u65b0\u4e3a\u5f02\u5e38\uff01");
                exceptions.add(visitPlanDetailException);
            }
            this.visitPlanDetailRepository.saveOrUpdateBatch(list);
            this.visitPlanDetailExceptionService.createBatch(exceptions);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<VisitPlanDetail> findByClientCodesAndClientTypeAndVisitStatus(Set<String> clientCodes, String clientType, String visitStatus) {
        if (CollectionUtils.isEmpty(clientCodes) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{clientType, visitStatus})) {
            return new ArrayList<VisitPlanDetail>(0);
        }
        return this.visitPlanDetailRepository.findByClientCodesAndClientTypeAndVisitStatus(clientCodes, clientType, visitStatus);
    }

    @Override
    public VisitPlanDetail findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (VisitPlanDetail)((Object)this.visitPlanDetailRepository.getById((Serializable)((Object)id)));
    }
}

