/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailVoRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanRepository;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class VisitPlanDetailVoServiceImpl
implements VisitPlanDetailVoService {
    @Autowired
    private List<VisitPlanDetailObserver> visitPlanDetailObservers;
    @Autowired
    private VisitPlanDetailRepository visitPlanDetailRepository;
    @Autowired
    private VisitPlanDetailVoRepository visitPlanDetailVoRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VisitPlanRepository visitPlanRepository;
    @Autowired
    private List<ClientRouteStrategy> visitPlanClientRouteStrategies;

    @Transactional
    public void createBatchByVisitPlanDetailDto(List<VisitPlanDetailDto> visitPlanDetailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanDetailDtos) ? 1 : 0) != 0, (String)"\u6279\u91cf\u521b\u5efa\u6570\u636e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.visitPlanDetailObservers) ? 1 : 0) != 0, (String)"\u6279\u91cf\u521b\u5efa\u6570\u636e\u65f6\uff0c\u4e3a\u67e5\u8be2\u5230\u660e\u7ec6\u89c2\u5bdf\u8005\u5b9e\u73b0\u7c7b\uff01", (Object[])new Object[0]);
        ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<VisitPlanDetailModel>();
        Map map = visitPlanDetailDtos.stream().collect(Collectors.groupingBy(VisitPlanDetailDto::getVisitRouteType, Collectors.mapping(VisitPlanDetailDto::getVisitPlanCode, Collectors.toList())));
        for (VisitPlanDetailObserver visitPlanDetailObserver : this.visitPlanDetailObservers) {
            List models = visitPlanDetailObserver.onRequestVisitDetailDto(map);
            visitPlanDetailModels.addAll(models);
        }
        this.createBatch(visitPlanDetailModels);
    }

    @Transactional
    public void updateBatchByVisitPlanDetailDto(List<VisitPlanDetailDto> visitPlanDetailDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanDetailDtos) ? 1 : 0) != 0, (String)"\u6279\u91cf\u521b\u5efa\u6570\u636e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(this.visitPlanDetailObservers) ? 1 : 0) != 0, (String)"\u6279\u91cf\u521b\u5efa\u6570\u636e\u65f6\uff0c\u4e3a\u67e5\u8be2\u5230\u660e\u7ec6\u89c2\u5bdf\u8005\u5b9e\u73b0\u7c7b\uff01", (Object[])new Object[0]);
        ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<VisitPlanDetailModel>();
        Map map = visitPlanDetailDtos.stream().collect(Collectors.groupingBy(VisitPlanDetailDto::getVisitRouteType, Collectors.mapping(VisitPlanDetailDto::getVisitPlanCode, Collectors.toList())));
        for (VisitPlanDetailObserver visitPlanDetailObserver : this.visitPlanDetailObservers) {
            List models = visitPlanDetailObserver.onRequestVisitDetailDto(map);
            visitPlanDetailModels.addAll(models);
        }
        this.updateBatch(visitPlanDetailModels);
    }

    @Transactional
    public void createBatch(List<VisitPlanDetailModel> dto) {
        Validate.isTrue((!CollectionUtils.isEmpty(dto) ? 1 : 0) != 0, (String)"\u6279\u91cf\u521b\u5efa\u6570\u636e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List visitPlanDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dto, VisitPlanDetailModel.class, VisitPlanDetail.class, HashSet.class, ArrayList.class, new String[0]);
        Set<String> planCodes = visitPlanDetails.stream().map(VisitPlanDetail::getVisitPlanCode).collect(Collectors.toSet());
        List<VisitPlan> visitPlans = this.visitPlanRepository.findByPlanCodes(planCodes);
        Map<Object, Object> planMap = new HashMap();
        if (!CollectionUtils.isEmpty(visitPlans)) {
            planMap = visitPlans.stream().collect(Collectors.toMap(VisitPlan::getVisitPlanCode, VisitPlan::getVisitUserName));
        }
        HashSet<String> userNameSets = new HashSet<String>();
        HashSet<Date> visitDateSets = new HashSet<Date>();
        HashSet<String> clientCodeSets = new HashSet<String>();
        HashSet<String> visitStatusSets = new HashSet<String>();
        for (VisitPlanDetail visitPlanDetail : visitPlanDetails) {
            this.createValidate(visitPlanDetail);
            String userName = (String)planMap.get(visitPlanDetail.getVisitPlanCode());
            visitPlanDetail.setVisitUserName(userName);
            visitDateSets.add(visitPlanDetail.getVisitDate());
            clientCodeSets.add(visitPlanDetail.getClientCode());
            userNameSets.add(userName);
        }
        visitStatusSets.add(VisitStatusEnum.NOT_VISIT.getDictCode());
        visitStatusSets.add(VisitStatusEnum.IN_THE_VISIT.getDictCode());
        List<VisitPlanDetailVo> detailList = this.visitPlanDetailVoRepository.findByUserNamesAndClientCodesAndVisitDatesAndVisitStatus(userNameSets, clientCodeSets, visitDateSets, visitStatusSets);
        if (!CollectionUtils.isEmpty(detailList)) {
            Map<String, List<VisitPlanDetailVo>> listMap = detailList.stream().collect(Collectors.groupingBy(detail -> StringUtils.joinWith((String)"_", (Object[])new Object[]{detail.getVisitUserName(), detail.getClientCode(), DateFormatUtils.format((Date)detail.getVisitDate(), (String)"yyyy_MM-dd")})));
            visitPlanDetails = visitPlanDetails.stream().filter(detail -> null == listMap.get(StringUtils.joinWith((String)"_", (Object[])new Object[]{detail.getVisitUserName(), detail.getClientCode(), DateFormatUtils.format((Date)detail.getVisitDate(), (String)"yyyy_MM-dd")}))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)visitPlanDetails)) {
            return;
        }
        this.buildVisitPlanDetails(visitPlanDetails);
        this.visitPlanDetailRepository.saveBatch(visitPlanDetails);
    }

    @Transactional
    public void updateBatch(List<VisitPlanDetailModel> dto) {
        Validate.isTrue((!CollectionUtils.isEmpty(dto) ? 1 : 0) != 0, (String)"\u6279\u91cf\u66f4\u65b0\u6570\u636e\u65f6\uff0c\u5165\u53c2\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List visitPlanDetails = (List)this.nebulaToolkitService.copyCollectionByWhiteList(dto, VisitPlanDetailModel.class, VisitPlanDetail.class, HashSet.class, ArrayList.class, new String[0]);
        HashSet<String> visitPlanCodes = new HashSet<String>();
        visitPlanDetails.stream().forEach(visitPlanDetail -> {
            this.createValidate((VisitPlanDetail)((Object)visitPlanDetail));
            visitPlanCodes.add(visitPlanDetail.getVisitPlanCode());
        });
        this.visitPlanDetailRepository.deleteByVisitPlanCodes(visitPlanCodes);
        this.createBatch(dto);
    }

    public Page<VisitPlanDetailVo> findByConditions(Pageable pageable, VisitPlanDetailQueryDto dto) {
        Page<VisitPlanDetailVo> page;
        List records;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new VisitPlanDetailQueryDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (dto.getVisitDateMonth() != null) {
            dto.setVisitDateMonthStr(DateFormatUtils.format((Date)dto.getVisitDateMonth(), (String)"yyyy-MM"));
        }
        if (CollectionUtils.isEmpty((Collection)(records = (page = this.visitPlanDetailVoRepository.findByConditions(pageable, dto)).getRecords()))) {
            return new Page();
        }
        this.buildVisitPlanDetailVos(records);
        return page;
    }

    public List<VisitPlanDetailVo> findByConditions(VisitPlanDetailQueryDto dto) {
        if (Objects.isNull(dto)) {
            dto = new VisitPlanDetailQueryDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<VisitPlanDetailVo> conditions = this.visitPlanDetailVoRepository.findByConditions(dto);
        this.buildVisitPlanDetailVos(conditions);
        return conditions;
    }

    private void createValidate(VisitPlanDetail visitPlanDetail) {
        Validate.notNull((Object)((Object)visitPlanDetail), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanDetail.setId(null);
        Validate.notBlank((CharSequence)visitPlanDetail.getClientCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanDetail.getClientType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)visitPlanDetail.getVisitDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanDetail.getVisitPlanCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanDetail.getVisitStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanDetail.setVisitYearMonth(DateFormatUtils.format((Date)visitPlanDetail.getVisitDate(), (String)"yyyy-MM"));
    }

    private void buildVisitPlanDetailVos(List<VisitPlanDetailVo> records) {
        Map clientMap = records.stream().collect(Collectors.groupingBy(VisitPlanDetailVo::getClientRoute, Collectors.groupingBy(VisitPlanDetailVo::getClientType, Collectors.mapping(VisitPlanDetailVo::getClientCode, Collectors.toList()))));
        if (CollectionUtils.isEmpty(this.visitPlanClientRouteStrategies)) {
            return;
        }
        ArrayList infoVos = new ArrayList();
        for (ClientRouteStrategy clientRouteStrategy : this.visitPlanClientRouteStrategies) {
            Map listMap = clientMap.get(clientRouteStrategy.getKey());
            if (listMap == null) continue;
            List terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
            List dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
            infoVos.addAll(terminalVos);
            infoVos.addAll(dealerVos);
        }
        Map<Object, Object> infoVoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(infoVos)) {
            infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"_", (Object[])new Object[]{o.getClientRoute(), o.getClientType(), o.getClientCode()})));
        }
        for (VisitPlanDetailVo visitPlanDetailVo : records) {
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{visitPlanDetailVo.getClientRoute(), visitPlanDetailVo.getClientType(), visitPlanDetailVo.getClientCode()});
            List vos = (List)infoVoHashMap.get(key);
            if (CollectionUtils.isEmpty((Collection)vos)) continue;
            ClientRouteInfoVo vo = (ClientRouteInfoVo)vos.get(0);
            BeanUtil.copyProperties((Object)vo, (Object)visitPlanDetailVo, (String[])new String[0]);
        }
    }

    private void buildVisitPlanDetails(List<VisitPlanDetail> records) {
        Map clientMap = records.stream().collect(Collectors.groupingBy(VisitPlanDetail::getClientRoute, Collectors.groupingBy(VisitPlanDetail::getClientType, Collectors.mapping(VisitPlanDetail::getClientCode, Collectors.toList()))));
        if (CollectionUtils.isEmpty(this.visitPlanClientRouteStrategies)) {
            return;
        }
        ArrayList infoVos = new ArrayList();
        for (ClientRouteStrategy clientRouteStrategy : this.visitPlanClientRouteStrategies) {
            Map listMap = clientMap.get(clientRouteStrategy.getKey());
            if (listMap == null) continue;
            List terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
            List dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
            infoVos.addAll(terminalVos);
            infoVos.addAll(dealerVos);
        }
        Map<Object, Object> infoVoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(infoVos)) {
            infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"_", (Object[])new Object[]{o.getClientRoute(), o.getClientType(), o.getClientCode()})));
        }
        for (VisitPlanDetail visitPlanDetail : records) {
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{visitPlanDetail.getClientRoute(), visitPlanDetail.getClientType(), visitPlanDetail.getClientCode()});
            List vos = (List)infoVoHashMap.get(key);
            if (CollectionUtils.isEmpty((Collection)vos)) continue;
            ClientRouteInfoVo vo = (ClientRouteInfoVo)vos.get(0);
            BeanUtil.copyProperties((Object)vo, (Object)((Object)visitPlanDetail), (String[])new String[0]);
        }
    }
}

