/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailService;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanService;
import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanEventDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitPlanTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanRouteRangeModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.register.VisitPlanRouteRegister;
import com.biz.crm.sfa.business.visit.plan.sdk.strategy.VisitPlanRouteStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanService")
public class VisitPlanServiceImpl
implements VisitPlanService {
    @Autowired
    private VisitPlanRepository visitPlanRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<VisitPlanRouteRegister> visitPlanRouteRegisters;
    @Autowired(required=false)
    private List<VisitPlanRouteStrategy> visitPlanRouteStrategies;
    @Autowired(required=false)
    private List<VisitPlanDetailObserver> visitPlanDetailObservers;
    @Autowired
    private VisitPlanDetailService visitPlanDetailService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    public Page<VisitPlan> findByConditions(Pageable pageable, VisitPlanQueryDto visitPlanQueryDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(visitPlanQueryDto)) {
            visitPlanQueryDto = new VisitPlanQueryDto();
        }
        visitPlanQueryDto.setTenantCode(TenantUtils.getTenantCode());
        Page<VisitPlan> conditions = this.visitPlanRepository.findByConditions(pageable, visitPlanQueryDto);
        List records = conditions.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return new Page();
        }
        return conditions;
    }

    @Override
    public VisitPlan findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        VisitPlan visitPlan = (VisitPlan)((Object)this.visitPlanRepository.getById((Serializable)((Object)id)));
        if (visitPlan == null) {
            return null;
        }
        if (!CollectionUtils.isEmpty(this.visitPlanRouteStrategies)) {
            for (VisitPlanRouteStrategy visitPlanRouteStrategy : this.visitPlanRouteStrategies) {
                if (!visitPlanRouteStrategy.getKey().equals(visitPlan.getVisitRouteType())) continue;
                VisitPlanRouteRangeAbstract visitPlanRouteRangeAbstract = visitPlanRouteStrategy.onFindRouteRange(visitPlan.getVisitPlanCode());
                visitPlan.setVisitPlanRouteRangeAbstract(visitPlanRouteRangeAbstract);
                break;
            }
        }
        return visitPlan;
    }

    @Override
    @Transactional
    public VisitPlan create(JSONObject jsonObject) {
        VisitPlan visitPlan = this.getVisitPlan(jsonObject);
        this.createValidate(visitPlan);
        jsonObject.put("visitPlanCode", (Object)visitPlan.getVisitPlanCode());
        Validate.isTrue((!CollectionUtils.isEmpty(this.visitPlanRouteStrategies) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u521b\u5efa\u8ba1\u5212\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u7ef4\u5ea6\u7b56\u7565\u5b9e\u73b0\uff01", (Object[])new Object[0]);
        for (VisitPlanRouteStrategy visitPlanRouteStrategy : this.visitPlanRouteStrategies) {
            if (!StringUtils.equals((CharSequence)visitPlanRouteStrategy.getKey(), (CharSequence)visitPlan.getVisitRouteType())) continue;
            VisitPlanRouteRangeModel visitPlanRouteRangeModel = visitPlanRouteStrategy.onCreate(jsonObject);
            visitPlan.setStartDate(visitPlanRouteRangeModel.getStartDate());
            visitPlan.setEndDate(visitPlanRouteRangeModel.getEndDate());
            break;
        }
        this.visitPlanRepository.saveOrUpdate((Object)visitPlan);
        Validate.isTrue((!CollectionUtils.isEmpty(this.visitPlanDetailObservers) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u521b\u5efa\u8ba1\u5212\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u89c2\u5bdf\u8005\u5b9e\u73b0\u7c7b\uff01", (Object[])new Object[0]);
        HashMap<String, ArrayList> listMap = new HashMap<String, ArrayList>();
        listMap.put(visitPlan.getVisitRouteType(), Lists.newArrayList((Object[])new String[]{visitPlan.getVisitPlanCode()}));
        for (VisitPlanDetailObserver visitPlanDetailObserver : this.visitPlanDetailObservers) {
            visitPlanDetailObserver.onCreate(listMap);
        }
        return visitPlan;
    }

    @Override
    @Transactional
    public VisitPlan update(JSONObject jsonObject) {
        VisitPlan visitPlan = this.getVisitPlan(jsonObject);
        Validate.notBlank((CharSequence)visitPlan.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlan old = (VisitPlan)((Object)this.visitPlanRepository.getById((Serializable)((Object)visitPlan.getId())));
        Validate.notNull((Object)((Object)old), (String)"\u4fee\u6539\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u4fe1\u606f\uff01", (Object[])new Object[0]);
        VisitPlanEventDto visitPlanEventDto = new VisitPlanEventDto();
        visitPlanEventDto.setOriginal(JsonUtils.toJSONObject((Object)((Object)old)));
        BeanUtils.copyProperties((Object)((Object)visitPlan), (Object)((Object)old), (String[])new String[]{"id", "visitPlanCode", "tenantCode", "delFlag", "enableStatus", "createAccount", "createTime", "createName"});
        this.updateValidate(old);
        jsonObject.put("visitPlanCode", (Object)old.getVisitPlanCode());
        Validate.notNull(this.visitPlanRouteStrategies, (String)"\u8fdb\u884c\u521b\u5efa\u8ba1\u5212\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u7ef4\u5ea6\u7b56\u7565\u5b9e\u73b0\uff01", (Object[])new Object[0]);
        for (VisitPlanRouteStrategy visitPlanRouteStrategy : this.visitPlanRouteStrategies) {
            if (!StringUtils.equals((CharSequence)visitPlanRouteStrategy.getKey(), (CharSequence)old.getVisitRouteType())) continue;
            VisitPlanRouteRangeModel visitPlanRouteRangeModel = visitPlanRouteStrategy.onUpdate(jsonObject);
            old.setStartDate(visitPlanRouteRangeModel.getStartDate());
            old.setEndDate(visitPlanRouteRangeModel.getEndDate());
            break;
        }
        this.visitPlanRepository.saveOrUpdate((Object)old);
        Validate.isTrue((!CollectionUtils.isEmpty(this.visitPlanDetailObservers) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u521b\u5efa\u8ba1\u5212\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u89c2\u5bdf\u8005\u5b9e\u73b0\u7c7b\uff01", (Object[])new Object[0]);
        HashMap<String, ArrayList> listMap = new HashMap<String, ArrayList>();
        listMap.put(visitPlan.getVisitRouteType(), Lists.newArrayList((Object[])new String[]{visitPlan.getVisitPlanCode()}));
        for (VisitPlanDetailObserver visitPlanDetailObserver : this.visitPlanDetailObservers) {
            visitPlanDetailObserver.onUpdate(listMap);
        }
        return visitPlan;
    }

    private VisitPlan getVisitPlan(JSONObject jsonObject) {
        Validate.notNull((Object)jsonObject, (String)"\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u4fe1\u606f", (Object[])new Object[0]);
        JSONObject templateJson = jsonObject.getJSONObject("visitPlan");
        Validate.notNull((Object)jsonObject, (String)"\u672a\u83b7\u53d6\u5230\u62dc\u8bbf\u8ba1\u5212\u4fe1\u606f", (Object[])new Object[0]);
        boolean hasRouteData = false;
        for (VisitPlanRouteRegister routeRegister : this.visitPlanRouteRegisters) {
            Object policyData = jsonObject.get((Object)routeRegister.getKey());
            if (!Objects.nonNull(policyData)) continue;
            hasRouteData = true;
            break;
        }
        Validate.isTrue((boolean)hasRouteData, (String)"\u521b\u5efa\u62dc\u8bbf\u8ba1\u5212\u65f6\u9700\u8981\u6307\u5b9a\u7ef4\u5ea6\u5185\u5bb9\uff01", (Object[])new Object[0]);
        VisitPlan visitPlan = (VisitPlan)((Object)JsonUtils.json2Obj((String)templateJson.toJSONString(), VisitPlan.class));
        return visitPlan;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlan> list = this.visitPlanRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        this.visitPlanRepository.updateDelFlagByIds(idList, DelFlagStatusEnum.DELETE);
        Set<String> visitPlanCodes = list.stream().map(VisitPlan::getVisitPlanCode).collect(Collectors.toSet());
        this.visitPlanDetailService.deleteByVisitPlanCodesAndVisitStatus(visitPlanCodes, VisitStatusEnum.NOT_VISIT.getDictCode());
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlan> list = this.visitPlanRepository.findByIds(idList);
        List disable = list.stream().filter(visitPlan -> EnableStatusEnum.DISABLE.getCode().equals(visitPlan.getEnableStatus())).collect(Collectors.toList());
        Validate.isTrue((!CollectionUtils.isEmpty(disable) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u8981\u542f\u7528\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        this.visitPlanRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
        Validate.isTrue((!CollectionUtils.isEmpty(this.visitPlanDetailObservers) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u521b\u5efa\u8ba1\u5212\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u89c2\u5bdf\u8005\u5b9e\u73b0\u7c7b\uff01", (Object[])new Object[0]);
        Map map = list.stream().collect(Collectors.groupingBy(VisitPlan::getVisitRouteType, Collectors.mapping(VisitPlan::getVisitPlanCode, Collectors.toList())));
        for (VisitPlanDetailObserver visitPlanDetailObserver : this.visitPlanDetailObservers) {
            visitPlanDetailObserver.onUpdate(map);
        }
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<VisitPlan> list = this.visitPlanRepository.findByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u6570\u636e\uff01", (Object[])new Object[0]);
        this.visitPlanRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
        Set<String> visitPlanCodes = list.stream().map(VisitPlan::getVisitPlanCode).collect(Collectors.toSet());
        this.visitPlanDetailService.deleteByVisitPlanCodesAndVisitStatus(visitPlanCodes, VisitStatusEnum.NOT_VISIT.getDictCode());
    }

    private void createValidate(VisitPlan visitPlan) {
        Validate.notNull((Object)((Object)visitPlan), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlan.setId(null);
        visitPlan.setVisitPlanCode((String)this.generateCodeService.generateCode("BFJH", 1).get(0));
        visitPlan.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        visitPlan.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        visitPlan.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)visitPlan.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlan.getVisitPlanType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlanTypeEnum visitPlanTypeEnum = VisitPlanTypeEnum.getByDictCode((String)visitPlan.getVisitPlanType());
        Validate.notNull((Object)visitPlanTypeEnum, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlan.getVisitRouteType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean hasRouteData = false;
        for (VisitPlanRouteRegister routeRegister : this.visitPlanRouteRegisters) {
            if (!StringUtils.equals((CharSequence)routeRegister.getKey(), (CharSequence)visitPlan.getVisitRouteType())) continue;
            hasRouteData = true;
            break;
        }
        Validate.notNull((Object)hasRouteData, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(VisitPlan visitPlan) {
        Validate.notNull((Object)((Object)visitPlan), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlan.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlan.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlan.getVisitPlanType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlanTypeEnum visitPlanTypeEnum = VisitPlanTypeEnum.getByDictCode((String)visitPlan.getVisitPlanType());
        Validate.notNull((Object)visitPlanTypeEnum, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlan.getVisitRouteType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean hasRouteData = false;
        for (VisitPlanRouteRegister routeRegister : this.visitPlanRouteRegisters) {
            if (!StringUtils.equals((CharSequence)routeRegister.getKey(), (CharSequence)visitPlan.getVisitRouteType())) continue;
            hasRouteData = true;
            break;
        }
        Validate.notNull((Object)hasRouteData, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
    }
}

