package com.biz.crm.sfa.business.visit.plan.local.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 拜访计划制定表(VisitPlan)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
@RestController
@RequestMapping("/v1/visitPlan/visitPlan")
@Slf4j
@Api(tags = "拜访计划:VisitPlan:拜访计划制定")
public class VisitPlanController {
  /**
   * 服务对象
   */
  @Autowired
  private VisitPlanService visitPlanService;

  /**
   * 分页查询所有数据
   *
   * @param pageable          分页对象
   * @param visitPlanQueryDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<VisitPlan>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                  @ApiParam(name = "visitPlanQueryDto", value = "拜访计划查询dto") VisitPlanQueryDto visitPlanQueryDto) {
    try {
      Page<VisitPlan> page = this.visitPlanService.findByConditions(pageable, visitPlanQueryDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<VisitPlan> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      VisitPlan visitPlan = this.visitPlanService.findById(id);
      return Result.ok(visitPlan);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增拜访计划数据，入参为jsonObject(包含新增拜访计划维度数据)
   * 示例： todo
   *
   * @param jsonObject 实体对象
   * @return 新增结果
   */
  @ApiOperation(value = "新增拜访计划数据，入参为jsonObject(包含新增拜访计划维度数据)")
  @PostMapping
  public Result<VisitPlan> create(@ApiParam(name = "jsonObject", value = "拜访计划数据") @RequestBody JSONObject jsonObject) {
    try {
      VisitPlan result = this.visitPlanService.create(jsonObject);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改拜访计划数据，入参为jsonObject(包含新增拜访计划维度数据)
   * 示例： todo
   *
   * @param jsonObject 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改拜访计划数据，入参为jsonObject(包含修改拜访计划维度数据)")
  @PatchMapping
  public Result<VisitPlan> update(@ApiParam(name = "visitPlan", value = "拜访计划数据") @RequestBody JSONObject jsonObject) {
    try {
      VisitPlan result = this.visitPlanService.update(jsonObject);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 修改拜访计划数据，入参为jsonObject(包含新增拜访计划维度数据)
   * - 因为网关问题未修复好
   * - 为小程序不能发起patch请求
   *
   * @param jsonObject 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改拜访计划数据，入参为jsonObject(包含修改拜访计划维度数据)")
  @PostMapping("updateTurnPatch")
  public Result<VisitPlan> updateTurnPatch(@ApiParam(name = "visitPlan", value = "拜访计划数据") @RequestBody JSONObject jsonObject) {
    return this.update(jsonObject);
  }

  /**
   * 删除数据
   *
   * @param ids 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.visitPlanService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  @PatchMapping("enable")
  @ApiOperation(value = "启用（单个或者批量）")
  public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.visitPlanService.enable(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  @PatchMapping("disable")
  @ApiOperation(value = "禁用（单个或者批量）")
  public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.visitPlanService.disable(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
