package com.biz.crm.sfa.business.visit.plan.local.controller;


import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailClientVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailClientVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

/**
 * 拜访计划明细客户(visitPlanDetailClientVo)相关的http接口
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@RestController
@RequestMapping("/v1/visitPlanDetail/visitPlanDetailClientVo")
@Slf4j
@Api(tags = "拜访计划:VisitPlanDetailClientVo:拜访计划明细客户Vo")
public class VisitPlanDetailClientVoController {

  @Autowired
  private VisitPlanDetailClientVoService visitPlanDetailClientVoService;

  /**
   * 根据人员账号和拜访时间和客户类型查询拜访计划的客户信息
   *
   * @param userName   人员账号
   * @param visitDate  客户类型
   * @param clientType 拜访日期
   * @return 所有数据
   */
  @ApiOperation(value = "根据人员账号和拜访时间和客户类型查询拜访计划的客户信息")
  @GetMapping("findByUserNameAndVisitDateAndClientType")
  public Result<List<VisitPlanDetailClientVo>> findByUserNameAndVisitDateAndClientType(@ApiParam(name = "userName", value = "人员账号") @RequestParam String userName,
                                                                                       @ApiParam(name = "clientType", value = "客户类型") @RequestParam String clientType,
                                                                                       @ApiParam(name = "visitDate", value = "拜访日期") @RequestParam @DateTimeFormat(pattern = "yyyy-MM-dd") Date visitDate) {
    try {
      List<VisitPlanDetailClientVo> page = this.visitPlanDetailClientVoService.findByUserNameAndVisitDateAndClientType(userName, clientType, visitDate);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
