package com.biz.crm.sfa.business.visit.plan.local.controller;


import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 拜访计划明细表(VisitPlanDetail)表相关的http接口
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@RestController
@RequestMapping("/v1/visitPlanDetail/visitPlanDetail")
@Slf4j
@Api(tags = "拜访计划:VisitPlanDetail:拜访计划明细表")
public class VisitPlanDetailController {
  /**
   * 服务对象
   */
  @Autowired
  private VisitPlanDetailService visitPlanDetailService;
  @Autowired
  private LoginUserService loginUserService;

  /**
   * 删除数据
   *
   * @param ids 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "ids", value = "主键集合") @RequestParam("ids") List<String> ids) {
    try {
      this.visitPlanDetailService.delete(ids);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据拜访日期查看当前用户的进度接口
   *
   * @return {"completed":"已完成数量","total":"总数量"}
   */
  @ApiOperation("根据拜访日期查看当前用户的进度接口")
  @GetMapping("findScheduleByCurrentUserAndVisitDate")
  public Result<?> findScheduleByCurrentUserAndVisitDate(@ApiParam(name = "visitDate", value = "拜访日期") @RequestParam("visitDate") @DateTimeFormat(pattern = "yyyy-MM-dd") Date visitDate) {
    try {
      FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
      Map<String, Integer> map = this.visitPlanDetailService.findScheduleByUserNameAndVisitDate(loginDetails.getAccount(), visitDate);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 执行任务，每天零时5分结束前一天的拜访中任务
   */
  @ApiOperation("")
  @PostMapping("executeTask")
  public Result<?> executeTask() {
    try {
      this.visitPlanDetailService.executeTask();
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<VisitPlanDetail> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      VisitPlanDetail visitPlan = this.visitPlanDetailService.findById(id);
      return Result.ok(visitPlan);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
