package com.biz.crm.sfa.business.visit.plan.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailDto;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 拜访计划明细表(VisitPlanDetailVo)相关的http接口
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@RestController
@RequestMapping("/v1/visitPlanDetail/visitPlanDetailVo")
@Slf4j
@Api(tags = "拜访计划:VisitPlanDetailVo:拜访计划明细Vo")
public class VisitPlanDetailVoController {

  @Autowired
  private VisitPlanDetailVoService visitPlanDetailVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<VisitPlanDetailVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "拜访计划明细查询dto") VisitPlanDetailQueryDto dto) {
    try {
      Page<VisitPlanDetailVo> page = this.visitPlanDetailVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动刷新执行计划明细
   *
   * @param dtos 入参集合
   * @return
   */
  @ApiOperation(value = "手动刷新执行计划明细")
  @PostMapping
  public Result<?> create(@ApiParam(name = "dtos", value = "拜访计划明细请求集合") @RequestBody List<VisitPlanDetailDto> dtos) {
    try {
      this.visitPlanDetailVoService.updateBatchByVisitPlanDetailDto(dtos);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
