package com.biz.crm.sfa.business.visit.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 拜访计划明细 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan_detail")
@Table(name = "sfa_visit_plan_detail")
@ApiModel(value = "VisitPlanDetail", description = "拜访计划明细表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan_detail", comment = "拜访计划明细表")
public class VisitPlanDetail extends UuidOpEntity {

  private static final long serialVersionUID = 7022214277071025864L;
  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  @Column(name = "visit_plan_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '拜访计划编码'")
  private String visitPlanCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  @Column(name = "client_name", length = 64, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientName;
  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  @Column(name = "client_route", length = 255, nullable = false, columnDefinition = "varchar(64) COMMENT '客户维度'")
  private String clientRoute;

  /**
   * 拜访状态
   * {@link VisitStatusEnum#getDictCode()}
   */
  @ApiModelProperty("拜访状态")
  @Column(name = "visit_status", length = 64, nullable = false, columnDefinition = "varchar(255) COMMENT '拜访状态'")
  private String visitStatus;

  /**
   * 拜访日期
   */
  @ApiModelProperty("拜访日期")
  @Column(name = "visit_date", length = 20, nullable = false, columnDefinition = "date COMMENT '拜访日期'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date visitDate;

  /**
   * 拜访年月
   */
  @ApiModelProperty("拜访年月")
  @Column(name = "visit_year_month", length = 7, columnDefinition = "varchar(7) COMMENT '拜访年月'")
  private String visitYearMonth;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @Column(name = "visit_start_date", length = 20, columnDefinition = "datetime COMMENT '拜访开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitStartDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @Column(name = "visit_end_date", length = 20, columnDefinition = "datetime COMMENT '拜访结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitEndDate;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  @Transient
  @TableField(exist = false)
  private String visitUserName;


}
