package com.biz.crm.sfa.business.visit.plan.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailExceptionFile;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanDetailExceptionFileMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 拜访计划明细异常文件表(VisitPlanDetailExceptionFile)表数据库访问层
 *
 * @author songjingen
 * @since 2022-06-28 19:12:17
 */
@Component
public class VisitPlanDetailExceptionFileRepository extends ServiceImpl<VisitPlanDetailExceptionFileMapper, VisitPlanDetailExceptionFile> {

  /**
   * 根据异常id集合查看数据
   *
   * @param visitPlanDetailExceptionIds
   * @return
   */
  public List<VisitPlanDetailExceptionFile> findByVisitPlanDetailExceptionIds(List<String> visitPlanDetailExceptionIds) {
    return this.lambdaQuery().in(VisitPlanDetailExceptionFile::getVisitPlanDetailExceptionId, visitPlanDetailExceptionIds).list();
  }
}

