package com.biz.crm.sfa.business.visit.plan.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanDetailMapper;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 拜访计划明细表(VisitPlanDetail)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@Component
public class VisitPlanDetailRepository extends ServiceImpl<VisitPlanDetailMapper, VisitPlanDetail> {

  /**
   * 根据拜访计划编码和状态删除数据
   *
   * @param visitPlanCodes
   * @param visitStatus
   */
  public void deleteByVisitPlanCodesAndVisitStatus(Set<String> visitPlanCodes, String visitStatus) {
    this.lambdaUpdate().in(VisitPlanDetail::getVisitPlanCode, visitPlanCodes)
        .eq(VisitPlanDetail::getVisitStatus, visitStatus)
        .remove();
  }

  /**
   * 根据id修改拜访状态
   *
   * @param visitStatus
   * @param id
   */
  public void updateVisitStatusById(String visitStatus, String id) {
    this.lambdaUpdate().set(VisitPlanDetail::getVisitStatus, visitStatus)
        .eq(VisitPlanDetail::getId, id)
        .update();
  }

  /**
   * 根据用户账号查看数据
   *
   * @param visitDate
   * @param userName
   * @return
   */
  public List<VisitPlanDetail> findByVisitDateAndUserName(Date visitDate, String userName) {
    return this.baseMapper.findByVisitDateAndUserName(visitDate, userName);
  }

  /**
   * 根据拜访计划编码删除数据
   *
   * @param visitPlanCodes
   */
  public void deleteByVisitPlanCodes(Set<String> visitPlanCodes) {
    this.lambdaUpdate().in(VisitPlanDetail::getVisitPlanCode, visitPlanCodes)
        .remove();
  }

  /**
   * 根据状态和时间查询数据
   *
   * @param visitDate
   * @param visitStatus
   * @return
   */
  public List<VisitPlanDetail> findByVisitDateAndVisitStatus(Date visitDate, String visitStatus) {
    return this.lambdaQuery().eq(VisitPlanDetail::getVisitStatus, visitStatus)
        .eq(VisitPlanDetail::getVisitDate, visitDate)
        .list();
  }

  /**
   * 根据客户类型和客户编码查询数据
   *
   * @param clientCodes
   * @param clientType
   * @param visitStatus
   * @return
   */
  public List<VisitPlanDetail> findByClientCodesAndClientTypeAndVisitStatus(Set<String> clientCodes, String clientType, String visitStatus) {
    return this.lambdaQuery().eq(VisitPlanDetail::getClientType, clientType)
        .eq(VisitPlanDetail::getVisitStatus, visitStatus)
        .in(VisitPlanDetail::getClientCode, clientCodes)
        .list();
  }

  /**
   * 根究客户编码和人员账号和拜访时间查询数据
   *
   * @param clientCodes
   * @param userName
   * @param visitDate
   * @return
   */
  public List<VisitPlanDetail> findByClientCodesAndUserNameAndVisitDate(List<String> clientCodes, String userName, Date visitDate) {
    return this.lambdaQuery().eq(VisitPlanDetail::getVisitDate, visitDate)
        .eq(VisitPlanDetail::getVisitUserName, userName)
        .in(VisitPlanDetail::getClientCode, clientCodes)
        .list();
  }
}

