package com.biz.crm.sfa.business.visit.plan.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanDetailVoMapper;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 拜访计划明细表(VisitPlanDetailVo)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@Component
public class VisitPlanDetailVoRepository {

  @Autowired
  private VisitPlanDetailVoMapper visitPlanDetailVoMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      实体对象
   * @return
   */
  public Page<VisitPlanDetailVo> findByConditions(Pageable pageable, VisitPlanDetailQueryDto dto) {
    Page<VisitPlanDetail> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<VisitPlanDetailVo> pageList = this.visitPlanDetailVoMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 按照条件查询数据（不带分页)
   *
   * @param dto 实体对象
   * @return
   */
  public List<VisitPlanDetailVo> findByConditions(VisitPlanDetailQueryDto dto) {
    List<VisitPlanDetailVo> list = this.visitPlanDetailVoMapper.findByConditions(dto);
    return list;
  }

  /**
   * 用户(计划编码)+拜访时间+客户编码+拜访状态查询数据
   *
   * @param userNameSets
   * @param clientCodeSets
   * @param visitDateSets
   * @param visitStatusSets
   * @return
   */
  public List<VisitPlanDetailVo> findByUserNamesAndClientCodesAndVisitDatesAndVisitStatus(Set<String> userNameSets, Set<String> clientCodeSets, Set<Date> visitDateSets, Set<String> visitStatusSets) {
    return this.visitPlanDetailVoMapper.findByUserNamesAndClientCodesAndVisitDatesAndVisitStatus(userNameSets, clientCodeSets, visitDateSets, visitStatusSets);
  }
}

