package com.biz.crm.sfa.business.visit.plan.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlan;
import com.biz.crm.sfa.business.visit.plan.local.mapper.VisitPlanMapper;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanQueryDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;


/**
 * 拜访计划制定表(VisitPlan)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-06 11:15:39
 */
@Component
public class VisitPlanRepository extends ServiceImpl<VisitPlanMapper, VisitPlan> {

  @Autowired
  private VisitPlanMapper visitPlanMapper;

  /**
   * 分页查询数据
   *
   * @param pageable          分页对象
   * @param visitPlanQueryDto 查询对象
   * @return
   */
  public Page<VisitPlan> findByConditions(Pageable pageable, VisitPlanQueryDto visitPlanQueryDto) {
    Page<VisitPlan> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<VisitPlan> pageList = this.visitPlanMapper.findByConditions(page, visitPlanQueryDto);
    return pageList;
  }

  /**
   * 根据id集合更新启禁用装填
   *
   * @param ids          分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
        .in(VisitPlan::getId, ids)
        .set(VisitPlan::getEnableStatus, enableStatus.getCode())
        .update();
  }

  /**
   * 根据id集合查询数据
   *
   * @param idList
   * @return
   */
  public List<VisitPlan> findByIds(List<String> idList) {
    return this.lambdaQuery().in(VisitPlan::getId, idList).list();
  }

  /**
   * 修改删除状态
   *
   * @param idList
   * @param delFlagStatusEnum
   */
  public void updateDelFlagByIds(List<String> idList, DelFlagStatusEnum delFlagStatusEnum) {
    this.lambdaUpdate().in(VisitPlan::getId, idList).set(VisitPlan::getDelFlag, delFlagStatusEnum.getCode()).update();
  }

  public List<VisitPlan> findByPlanCodes(Set<String> planCodes) {
    return this.lambdaQuery().in(VisitPlan::getVisitPlanCode, planCodes).list();
  }
}

