package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailClientVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailClientVo;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 拜访计划明细客户vo(VisitPlanDetailClientVo)服务接口实现类
 *
 * @author songjingen
 * @since 2022-05-13 13:59:26
 */
@Service
public class VisitPlanDetailClientVoServiceImpl implements VisitPlanDetailClientVoService {

  @Autowired
  private VisitPlanDetailVoService visitPlanDetailVoService;

  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<VisitPlanDetailClientVo> findByUserNameAndVisitDateAndClientType(String userName, String clientType, Date visitDate) {
    if (StringUtils.isAnyBlank(userName, clientType) || visitDate == null) {
      return new ArrayList<>(0);
    }
    VisitPlanDetailQueryDto visitPlanDetailQueryDto = new VisitPlanDetailQueryDto();
    visitPlanDetailQueryDto.setTenantCode(TenantUtils.getTenantCode());
    visitPlanDetailQueryDto.setVisitUserName(userName);
    visitPlanDetailQueryDto.setClientType(clientType);
    visitPlanDetailQueryDto.setVisitDate(visitDate);
    List<VisitPlanDetailVo> visitPlanDetailVos = this.visitPlanDetailVoService.findByConditions(visitPlanDetailQueryDto);
    if (CollectionUtils.isEmpty(visitPlanDetailVos)) {
      return new ArrayList<>(0);
    }
    List<VisitPlanDetailClientVo> visitPlanDetailClientVos = (List<VisitPlanDetailClientVo>) this.nebulaToolkitService.copyCollectionByWhiteList(visitPlanDetailVos, VisitPlanDetailVo.class, VisitPlanDetailClientVo.class, HashSet.class, ArrayList.class);
    return visitPlanDetailClientVos.stream().distinct().collect(Collectors.toList());
  }
}
