package com.biz.crm.sfa.business.visit.plan.local.service.internal;


import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailExceptionFile;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailExceptionFileRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionFileService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 拜访计划明细异常文件表(VisitPlanDetailExceptionFile)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-28 19:12:17
 */
@Service("visitPlanDetailExceptionFileService")
public class VisitPlanDetailExceptionFileServiceImpl implements VisitPlanDetailExceptionFileService {

  @Autowired
  private VisitPlanDetailExceptionFileRepository visitPlanDetailExceptionFileRepository;


  /**
   * 创建验证
   *
   * @param visitPlanDetailExceptionFile
   */
  private void createValidate(VisitPlanDetailExceptionFile visitPlanDetailExceptionFile) {
    Validate.notNull(visitPlanDetailExceptionFile, "新增时，对象信息不能为空！");
    visitPlanDetailExceptionFile.setId(null);
    visitPlanDetailExceptionFile.setTenantCode(TenantUtils.getTenantCode());
    Validate.notBlank(visitPlanDetailExceptionFile.getVisitPlanDetailExceptionId(), "新增数据时，拜访计划明细异常id不能为空！");

  }

  @Transactional
  @Override
  public void createBatch(List<VisitPlanDetailExceptionFile> visitPlanDetailExceptionFiles) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanDetailExceptionFiles), "批量新增文件数据时，入参集合不能为空！");
    visitPlanDetailExceptionFiles.forEach(this::createValidate);
    this.visitPlanDetailExceptionFileRepository.saveBatch(visitPlanDetailExceptionFiles);
  }

  @Override
  public List<VisitPlanDetailExceptionFile> findByVisitPlanDetailExceptionIds(List<String> visitPlanDetailExceptionIds) {
    if (CollectionUtils.isEmpty(visitPlanDetailExceptionIds)) {
      return new ArrayList<>(0);
    }
    return this.visitPlanDetailExceptionFileRepository.findByVisitPlanDetailExceptionIds(visitPlanDetailExceptionIds);
  }
}

