package com.biz.crm.sfa.business.visit.plan.local.service.internal;


import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailException;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailExceptionFile;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailExceptionRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionFileService;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailExceptionService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 拜访计划明细异常表(VisitPlanDetailException)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-28 19:12:17
 */
@Service("visitPlanDetailExceptionService")
public class VisitPlanDetailExceptionServiceImpl implements VisitPlanDetailExceptionService {

  @Autowired
  private VisitPlanDetailExceptionRepository visitPlanDetailExceptionRepository;
  @Autowired
  private VisitPlanDetailExceptionFileService visitPlanDetailExceptionFileService;
  @Autowired
  private VisitPlanDetailRepository visitPlanDetailRepository;

  @Override
  public VisitPlanDetailException findByVisitPlanDetailId(String visitPlanDetailId) {
    if (StringUtils.isBlank(visitPlanDetailId)) {
      return null;
    }
    List<VisitPlanDetailException> visitPlanDetailExceptions = this.visitPlanDetailExceptionRepository.findByVisitPlanDetailId(visitPlanDetailId);
    if (visitPlanDetailExceptions == null) {
      return null;
    }
    VisitPlanDetailException visitPlanDetailException = visitPlanDetailExceptions.get(0);
    List<VisitPlanDetailExceptionFile> files = this.visitPlanDetailExceptionFileService.findByVisitPlanDetailExceptionIds(Lists.newArrayList(visitPlanDetailException.getId()));
    visitPlanDetailException.setPictureList(files);
    return visitPlanDetailException;
  }

  @Transactional
  @Override
  public void createBatch(List<VisitPlanDetailException> exceptions) {
    Validate.isTrue(!CollectionUtils.isEmpty(exceptions), "入参对象不能为空！");
    exceptions.forEach(this::createValidate);
    this.visitPlanDetailExceptionRepository.saveBatch(exceptions);
  }

  /**
   * 新增数据
   *
   * @param visitPlanDetailException 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public VisitPlanDetailException create(VisitPlanDetailException visitPlanDetailException) {
    this.createValidate(visitPlanDetailException);
    this.visitPlanDetailExceptionRepository.saveOrUpdate(visitPlanDetailException);
    //保存关联表数据
    List<VisitPlanDetailExceptionFile> pictureList = visitPlanDetailException.getPictureList();
    if (!CollectionUtils.isEmpty(pictureList)) {
      pictureList.forEach(visitPlanDetailExceptionFile -> visitPlanDetailExceptionFile.setVisitPlanDetailExceptionId(visitPlanDetailException.getId()));
      this.visitPlanDetailExceptionFileService.createBatch(pictureList);
    }
    //更新拜访计划拜访状态
    this.visitPlanDetailRepository.updateVisitStatusById(VisitStatusEnum.EXCEPTION.getDictCode(), visitPlanDetailException.getVisitPlanDetailId());
    return visitPlanDetailException;
  }

  /**
   * 创建验证
   *
   * @param visitPlanDetailException
   */
  private void createValidate(VisitPlanDetailException visitPlanDetailException) {
    Validate.notNull(visitPlanDetailException, "新增时，对象信息不能为空！");
    visitPlanDetailException.setId(null);
    Validate.notBlank(visitPlanDetailException.getRemark(), "新增数据时，异常信息不能为空！");
    Validate.notBlank(visitPlanDetailException.getVisitPlanDetailId(), "新增数据时，拜访计划明细id不能为空！");
    //验证是否已经提报异常
    List<VisitPlanDetailException> exceptions = this.visitPlanDetailExceptionRepository.findByVisitPlanDetailId(visitPlanDetailException.getVisitPlanDetailId());
    Validate.isTrue(CollectionUtils.isEmpty(exceptions), "当前计划已提报异常！");
  }
}

