package com.biz.crm.sfa.business.visit.plan.local.service.internal;


import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.service.DynamicTemplateService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailPerformance;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailPerformanceRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailPerformanceService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 拜访计划明细完成情况表(VisitPlanDetailPerformance)表服务实现类
 *
 * @author songjingen
 * @since 2022-06-21 16:42:20
 */
@Service("visitPlanDetailPerformanceService")
public class VisitPlanDetailPerformanceServiceImpl implements VisitPlanDetailPerformanceService {

  @Autowired
  private VisitPlanDetailPerformanceRepository visitPlanDetailPerformanceRepository;

  @Autowired(required = false)
  private StepFormVoService stepFormVoService;

  @Autowired
  private DynamicTemplateService dynamicTemplateService;


  /**
   * 新增数据
   *
   * @param visitPlanDetailPerformance 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public VisitPlanDetailPerformance create(VisitPlanDetailPerformance visitPlanDetailPerformance) {
    this.createValidate(visitPlanDetailPerformance);
    this.visitPlanDetailPerformanceRepository.saveOrUpdate(visitPlanDetailPerformance);
    return visitPlanDetailPerformance;
  }

  @Override
  public List<VisitPlanDetailPerformance> findByDetailId(String id) {
    if (StringUtils.isBlank(id)) {
      return new ArrayList<>();
    }
    List<VisitPlanDetailPerformance> list = this.visitPlanDetailPerformanceRepository.findByDetailId(id);
    if (CollectionUtils.isEmpty(list)) {
      return new ArrayList<>(0);
    }
    Set<String> stepCodes = list.stream().map(VisitPlanDetailPerformance::getStepCode).collect(Collectors.toSet());
    List<StepFormVo> stepFormVos = this.stepFormVoService.findByStepCodes(stepCodes);
    if (CollectionUtils.isEmpty(stepCodes)) {
      return new ArrayList<>(0);
    }
    Map<String, StepFormVo> stepFormVoMap = stepFormVos.stream().collect(Collectors.toMap(StepFormVo::getStepCode, o -> o));
    for (VisitPlanDetailPerformance performance : list) {
      StepFormVo stepFormVo = stepFormVoMap.get(performance.getStepCode());
      if (stepFormVo != null) {
        performance.setStepName(stepFormVo.getStepName());
        performance.setLogos(stepFormVo.getLogos());
      }
      //组装步骤数据
      DynamicTemplateModelDto dynamicTemplateModelDto = new DynamicTemplateModelDto();
      dynamicTemplateModelDto.setParentCode(performance.getVisitPlanDetailId());
      dynamicTemplateModelDto.setDynamicKey(performance.getStepCode());
      dynamicTemplateModelDto.setDynamicFormCode(performance.getFormCode());
      AbstractDynamicTemplateModel model = dynamicTemplateService.findByDynamicTemplateModelDto(dynamicTemplateModelDto);
      performance.setAbstractDynamicTemplateModel(model);
    }
    return list;
  }


  /**
   * 创建验证
   *
   * @param visitPlanDetailPerformance
   */
  private void createValidate(VisitPlanDetailPerformance visitPlanDetailPerformance) {
    Validate.notNull(visitPlanDetailPerformance, "新增时，对象信息不能为空！");
    visitPlanDetailPerformance.setId(null);
    Validate.notBlank(visitPlanDetailPerformance.getStepCode(), "新增数据时，步骤编码不能为空！");
    Validate.notBlank(visitPlanDetailPerformance.getVisitPlanDetailId(), "新增数据时，拜访计划明细id不能为空！");

  }

}

