package com.biz.crm.sfa.business.visit.plan.local.service.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanEventDto;
import com.biz.crm.sfa.business.visit.plan.sdk.event.VisitPlanLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 拜访计划制定日志
 *
 * @author songjingen
 * @date 2022/7/13
 */
@Component
public class VisitPlanLogEventBaseListener implements VisitPlanLogEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  @Override
  public void onCreate(VisitPlanEventDto eventDto) {
    // 新对象
    JSONObject newest = eventDto.getNewest();
    String onlyKey = newest.getString("id");
    // 旧对象
    JSONObject original = eventDto.getOriginal();
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onUpdate(VisitPlanEventDto eventDto) {
    // 新对象
    JSONObject newest = eventDto.getNewest();
    // 旧对象
    JSONObject original = eventDto.getOriginal();
    String onlyKey = original.getString("id");
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onEnable(VisitPlanEventDto eventDto) {
    //新对象
    JSONObject object = eventDto.getOriginal();
    String onlyKey = object.getString("id");
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传启禁用字段
    JSONObject oldObject = new JSONObject();
    JSONObject newObject = new JSONObject();
    oldObject.put("enableStatus", object.getString("enableStatus"));
    newObject.put("enableStatus", EnableStatusEnum.ENABLE.getCode());
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onDisable(VisitPlanEventDto eventDto) {
    //新对象
    JSONObject object = eventDto.getOriginal();
    String onlyKey = object.getString("id");
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传启禁用字段
    JSONObject oldObject = new JSONObject();
    JSONObject newObject = new JSONObject();
    oldObject.put("enableStatus", object.getString("enableStatus"));
    newObject.put("enableStatus", EnableStatusEnum.DISABLE.getCode());
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onRefresh(VisitPlanEventDto eventDto) {
    //新对象
    JSONObject object = eventDto.getOriginal();
    String onlyKey = object.getString("id");
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    //只需要传启禁用字段
    JSONObject oldObject = new JSONObject();
    JSONObject newObject = new JSONObject();
    newObject.put("refresh", "刷新成功");
    crmBusinessLogDto.setOldObject(oldObject);
    crmBusinessLogDto.setNewObject(newObject);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }

  @Override
  public void onDelete(VisitPlanEventDto eventDto) {
    // 新对象
    JSONObject newest = eventDto.getNewest();
    // 旧对象
    JSONObject original = eventDto.getOriginal();
    String onlyKey = original.getString("id");
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }
}
