/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.controller;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/visitPlanDetail/visitPlanDetail"})
@Api(tags={"\u62dc\u8bbf\u8ba1\u5212:VisitPlanDetail:\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u8868"})
public class VisitPlanDetailController {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanDetailController.class);
    @Autowired
    private VisitPlanDetailService visitPlanDetailService;
    @Autowired
    private LoginUserService loginUserService;

    @DeleteMapping
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.visitPlanDetailService.delete(ids);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u62dc\u8bbf\u65e5\u671f\u67e5\u770b\u5f53\u524d\u7528\u6237\u7684\u8fdb\u5ea6\u63a5\u53e3")
    @GetMapping(value={"findScheduleByCurrentUserAndVisitDate"})
    public Result<?> findScheduleByCurrentUserAndVisitDate(@ApiParam(name="visitDate", value="\u62dc\u8bbf\u65e5\u671f") @RequestParam(value="visitDate") @DateTimeFormat(pattern="yyyy-MM-dd") Date visitDate) {
        try {
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            Map<String, Integer> map = this.visitPlanDetailService.findScheduleByUserNameAndVisitDate(loginDetails.getAccount(), visitDate);
            return Result.ok(map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="")
    @PostMapping(value={"executeTask"})
    public Result<?> executeTask() {
        try {
            this.visitPlanDetailService.executeTask();
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<VisitPlanDetail> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            VisitPlanDetail visitPlan = this.visitPlanDetailService.findById(id);
            return Result.ok((Object)((Object)visitPlan));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

