/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.service.internal;

import com.biz.crm.sfa.business.step.sdk.service.StepFormVoService;
import com.biz.crm.sfa.business.step.sdk.vo.StepFormVo;
import com.biz.crm.sfa.business.template.sdk.abstracts.AbstractDynamicTemplateModel;
import com.biz.crm.sfa.business.template.sdk.dto.DynamicTemplateModelDto;
import com.biz.crm.sfa.business.template.sdk.service.DynamicTemplateService;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailPerformance;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailPerformanceRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailPerformanceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanDetailPerformanceService")
public class VisitPlanDetailPerformanceServiceImpl
implements VisitPlanDetailPerformanceService {
    @Autowired
    private VisitPlanDetailPerformanceRepository visitPlanDetailPerformanceRepository;
    @Autowired(required=false)
    private StepFormVoService stepFormVoService;
    @Autowired
    private DynamicTemplateService dynamicTemplateService;

    @Override
    @Transactional
    public VisitPlanDetailPerformance create(VisitPlanDetailPerformance visitPlanDetailPerformance) {
        this.createValidate(visitPlanDetailPerformance);
        this.visitPlanDetailPerformanceRepository.saveOrUpdate((Object)visitPlanDetailPerformance);
        return visitPlanDetailPerformance;
    }

    @Override
    public List<VisitPlanDetailPerformance> findByDetailId(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return new ArrayList<VisitPlanDetailPerformance>();
        }
        List<VisitPlanDetailPerformance> list = this.visitPlanDetailPerformanceRepository.findByDetailId(id);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<VisitPlanDetailPerformance>(0);
        }
        Set stepCodes = list.stream().map(VisitPlanDetailPerformance::getStepCode).collect(Collectors.toSet());
        List stepFormVos = this.stepFormVoService.findByStepCodes(stepCodes);
        if (CollectionUtils.isEmpty(stepCodes)) {
            return new ArrayList<VisitPlanDetailPerformance>(0);
        }
        Map<String, StepFormVo> stepFormVoMap = stepFormVos.stream().collect(Collectors.toMap(StepFormVo::getStepCode, o -> o));
        for (VisitPlanDetailPerformance performance : list) {
            StepFormVo stepFormVo = stepFormVoMap.get(performance.getStepCode());
            if (stepFormVo != null) {
                performance.setStepName(stepFormVo.getStepName());
                performance.setLogos(stepFormVo.getLogos());
            }
            DynamicTemplateModelDto dynamicTemplateModelDto = new DynamicTemplateModelDto();
            dynamicTemplateModelDto.setParentCode(performance.getVisitPlanDetailId());
            dynamicTemplateModelDto.setDynamicKey(performance.getStepCode());
            dynamicTemplateModelDto.setDynamicFormCode(performance.getFormCode());
            AbstractDynamicTemplateModel model = this.dynamicTemplateService.findByDynamicTemplateModelDto(dynamicTemplateModelDto);
            performance.setAbstractDynamicTemplateModel(model);
        }
        return list;
    }

    private void createValidate(VisitPlanDetailPerformance visitPlanDetailPerformance) {
        Validate.notNull((Object)((Object)visitPlanDetailPerformance), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanDetailPerformance.setId(null);
        Validate.notBlank((CharSequence)visitPlanDetailPerformance.getStepCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6b65\u9aa4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanDetailPerformance.getVisitPlanDetailId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

