/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.local.service.strategy;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.step.sdk.enums.VisitTypeEnum;
import com.biz.crm.sfa.business.step.sdk.strategy.ExecutePlanCallBackStrategy;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetail;
import com.biz.crm.sfa.business.visit.plan.local.entity.VisitPlanDetailPerformance;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailRepository;
import com.biz.crm.sfa.business.visit.plan.local.repository.VisitPlanDetailVoRepository;
import com.biz.crm.sfa.business.visit.plan.local.service.VisitPlanDetailPerformanceService;
import com.biz.crm.sfa.business.visit.plan.sdk.dto.VisitPlanDetailQueryDto;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.vo.VisitPlanDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ExecutePlanCallBackStrategyForVisit
implements ExecutePlanCallBackStrategy {
    @Autowired
    private VisitPlanDetailPerformanceService visitPlanDetailPerformanceService;
    @Autowired
    private VisitPlanDetailRepository visitPlanDetailRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private VisitPlanDetailVoRepository visitPlanDetailVoRepository;

    public String visitType() {
        return VisitTypeEnum.VISIT.getDictCode();
    }

    public String visitName() {
        return VisitTypeEnum.VISIT.getValue();
    }

    @Transactional
    public void onSave(String parentCode, String dynamicKey, String dynamicFormCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u4fdd\u5b58\u5b8c\u6210\u60c5\u51b5\u65f6\uff0c\u7236\u7ea7\u5173\u8054\u552f\u4e00\u7f16\u7801\uff08\u660e\u7ec6id\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicKey, (String)"\u4fdd\u5b58\u5b8c\u6210\u60c5\u51b5\u65f6\uff0c\u52a8\u6001key\uff08\u6b65\u9aa4\u7f16\u7801\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u4fdd\u5b58\u5b8c\u6210\u60c5\u51b5\u65f6\uff0c\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlanDetailPerformance helpDefensePlanDetailPerformance = new VisitPlanDetailPerformance();
        helpDefensePlanDetailPerformance.setVisitPlanDetailId(parentCode);
        helpDefensePlanDetailPerformance.setStepCode(dynamicKey);
        helpDefensePlanDetailPerformance.setFormCode(dynamicFormCode);
        this.visitPlanDetailPerformanceService.create(helpDefensePlanDetailPerformance);
    }

    public void onUpdateExecuteStatus(Boolean completeOrNot, String parentCode) {
        Date planDateTime = new Date();
        VisitPlanDetail visitPlanDetail = (VisitPlanDetail)((Object)this.visitPlanDetailRepository.getById((Serializable)((Object)parentCode)));
        if (completeOrNot.booleanValue()) {
            visitPlanDetail.setVisitStatus(VisitStatusEnum.VISIT_TO_COMPLETE.getDictCode());
            visitPlanDetail.setVisitEndDate(planDateTime);
        } else {
            FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            List<VisitPlanDetail> byUserNameAndVisitDate = this.visitPlanDetailRepository.findByVisitDateAndUserName(visitPlanDetail.getVisitDate(), loginDetails.getAccount());
            List planDetails = byUserNameAndVisitDate.stream().filter(detail -> detail.getVisitStatus().equals(VisitStatusEnum.IN_THE_VISIT.getDictCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(planDetails), (String)"\u5b58\u5728\u62dc\u8bbf\u4e2d\u7684\u8ba1\u5212\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u6b21\u62dc\u8bbf\uff01", (Object[])new Object[0]);
            visitPlanDetail.setVisitStatus(VisitStatusEnum.IN_THE_VISIT.getDictCode());
            if (visitPlanDetail.getVisitEndDate() == null) {
                visitPlanDetail.setVisitStartDate(planDateTime);
            }
        }
        this.visitPlanDetailRepository.saveOrUpdate((Object)visitPlanDetail);
    }

    public Set<String> onFindUserNamesByNowAndExecuteStatusIn() {
        try {
            String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
            VisitPlanDetailQueryDto dto = new VisitPlanDetailQueryDto();
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setVisitDate(nowDate);
            dto.setVisitStatus(VisitStatusEnum.IN_THE_VISIT.getDictCode());
            List<VisitPlanDetailVo> conditions = this.visitPlanDetailVoRepository.findByConditions(dto);
            if (CollectionUtils.isEmpty(conditions)) {
                return new HashSet<String>(0);
            }
            return conditions.stream().map(VisitPlanDetailVo::getVisitUserName).collect(Collectors.toSet());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

