package com.biz.crm.sfa.business.visit.plan.outlets.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 网点维度客户信息 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan_outlets_client_info")
@Table(name = "sfa_visit_plan_outlets_client_info")
@ApiModel(value = "VisitPlanOutletsClientInfo", description = "网点维度客户信息表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan_outlets_client_info", comment = "网点维度客户信息表")
public class VisitPlanOutletsClientInfo extends UuidEntity {

  private static final long serialVersionUID = 8840715398460223044L;
  /**
   * 网点拜访信息id
   */
  @ApiModelProperty("网点拜访信息id")
  @Column(name = "range_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '网点拜访信息id'")
  private String rangeId;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  @Column(name = "client_route", length = 255, nullable = false, columnDefinition = "varchar(64) COMMENT '客户维度'")
  private String clientRoute;

}
