package com.biz.crm.sfa.business.visit.plan.outlets.local.observer;

import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsRange;
import com.biz.crm.sfa.business.visit.plan.outlets.local.register.VisitPlanOutletsRouteRegister;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsClientInfoService;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访计划网点观察者实现类
 *
 * @author songjingen
 */
@Component
public class VisitPlanDetailOutletsObserver implements VisitPlanDetailObserver {

  @Autowired
  private VisitPlanOutletsRouteRegister visitPlanOutletsRouteRegister;

  @Autowired
  private VisitPlanOutletsRangeService visitPlanOutletsRangeService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitPlanDetailVoService visitPlanDetailVoService;

  @Autowired
  private VisitPlanOutletsClientInfoService visitPlanOutletsClientInfoService;

  @Override
  public List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map) {
    if (map == null) {
      return new ArrayList<>(0);
    }
    List<String> visitPlanCodes = map.get(visitPlanOutletsRouteRegister.getKey());
    if (CollectionUtils.isEmpty(visitPlanCodes)) {
      return new ArrayList<>(0);
    }
    List<VisitPlanOutletsRange> visitPlanLineRanges = this.visitPlanOutletsRangeService.findByVisitPlanCodes(visitPlanCodes);
    if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
      return new ArrayList<>(0);
    }
    List<String> rangeIds = visitPlanLineRanges.stream().map(VisitPlanOutletsRange::getId).collect(Collectors.toList());
    //按照rangeId分组后的map
    SimpleDateFormat weekSdf = new SimpleDateFormat("EE", Locale.CHINA);
    List<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<>();
    Map<String, List<VisitPlanOutletsClientInfo>> clientInfoMap = this.visitPlanOutletsClientInfoService.findByRangeIds(rangeIds);
    for (VisitPlanOutletsRange range : visitPlanLineRanges) {
      List<VisitPlanOutletsClientInfo> visitPlanLineRangeClientInfoVos = clientInfoMap.get(range.getId());
      if (CollectionUtils.isEmpty(visitPlanLineRangeClientInfoVos)) {
        continue;
      }
      String notWeekSet = range.getNotWeekSet();
      List<String> weekValues = new ArrayList<>();
      if (StringUtils.isNotBlank(notWeekSet)) {
        String[] split = notWeekSet.split(",");
        weekValues = VisitWeekTypeEnum.getValuesByDictCodes(Lists.newArrayList(split));
      }
      //计算天数
      int dayDiffer = this.getDayDiffer(range.getLoopsStartDate(), range.getLoopsEndDate());
      //循环日期天数生成明细model
      for (int i = 0; i < dayDiffer; i++) {
        Date visitDate = DateUtils.addDays(range.getLoopsStartDate(), i);
        //排除星期
        String week = weekSdf.format(visitDate);
        if (weekValues.contains(week)) {
          continue;
        }
        //循环线路组，并且客户信息正序
        List<VisitPlanDetailModel> models = (List<VisitPlanDetailModel>) this.nebulaToolkitService.copyCollectionByWhiteList(visitPlanLineRangeClientInfoVos, VisitPlanOutletsClientInfo.class, VisitPlanDetailModel.class, HashSet.class, ArrayList.class);
        models.stream().forEach(visitPlanDetailModel -> {
          visitPlanDetailModel.setVisitPlanCode(range.getVisitPlanCode());
          visitPlanDetailModel.setVisitDate(visitDate);
          visitPlanDetailModel.setVisitStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
        });
        visitPlanDetailModels.addAll(models);
      }
    }
    return visitPlanDetailModels;
  }

  @Override
  @Transactional
  public void onCreate(Map<String, List<String>> map) {
    List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
    if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
      this.visitPlanDetailVoService.createBatch(visitPlanDetailModels);
    }
  }

  @Transactional
  @Override
  public void onUpdate(Map<String, List<String>> map) {
    List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
    if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
      this.visitPlanDetailVoService.updateBatch(visitPlanDetailModels);
    }
  }

  /**
   * 计算开始时间，结束时间，间隔天数
   *
   * @param startDate
   * @param endDate
   * @return
   */
  private int getDayDiffer(Date startDate, Date endDate) {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    long startDateTime = 0;
    long endDateTime = 0;
    try {
      startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
      endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return (int) ((endDateTime - startDateTime) / (1000 * 3600 * 24)) + 1;
  }
}
