package com.biz.crm.sfa.business.visit.plan.outlets.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.mapper.VisitPlanOutletsClientInfoMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 网点维度客户信息表(VisitPlanOutletsClientInfo)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
@Component
public class VisitPlanOutletsClientInfoRepository extends ServiceImpl<VisitPlanOutletsClientInfoMapper, VisitPlanOutletsClientInfo> {

  /**
   * 根据网点维度id删除数据
   *
   * @param rangeId
   */
  public void deleteByRangeId(String rangeId) {
    this.lambdaUpdate().eq(VisitPlanOutletsClientInfo::getRangeId, rangeId).remove();
  }

  /**
   * 根据网点维度id查询数据
   *
   * @param rangeId
   */
  public List<VisitPlanOutletsClientInfo> findByRangeId(String rangeId) {
    return this.lambdaQuery().eq(VisitPlanOutletsClientInfo::getRangeId, rangeId).list();
  }

  /**
   * 根据rangeId集合查询数据
   *
   * @param rangeIds
   * @return
   */
  public List<VisitPlanOutletsClientInfo> findByRangeIds(List<String> rangeIds) {
    return this.lambdaQuery().in(VisitPlanOutletsClientInfo::getRangeId, rangeIds).list();
  }
}

