package com.biz.crm.sfa.business.visit.plan.outlets.local.service;


import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 网点维度客户信息表(VisitPlanOutletsClientInfo)表服务接口
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
public interface VisitPlanOutletsClientInfoService {

  /**
   * 新增数据(批量)
   *
   * @param visitPlanOutletsClientInfos 实体对象
   * @return 新增结果
   */
  void createBatch(Set<VisitPlanOutletsClientInfo> visitPlanOutletsClientInfos);

  /**
   * 根据网点维度id删除数据
   *
   * @param rangId 网点维度id
   * @return 删除结果
   */
  void deleteByRangeId(String rangId);

  /**
   * 根据网点维度id查询数据
   *
   * @param rangId 网点维度id
   * @return 删除结果
   */
  List<VisitPlanOutletsClientInfo> findByRangeId(String rangId);

  /**
   * 通过rangeId分组
   *
   * @param rangeIds
   * @return
   */
  Map<String, List<VisitPlanOutletsClientInfo>> findByRangeIds(List<String> rangeIds);
}

