package com.biz.crm.sfa.business.visit.plan.outlets.local.service.internal;


import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.repository.VisitPlanOutletsClientInfoRepository;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsClientInfoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 网点维度客户信息表(VisitPlanOutletsClientInfo)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
@Service("visitPlanOutletsClientInfoService")
public class VisitPlanOutletsClientInfoServiceImpl implements VisitPlanOutletsClientInfoService {

  @Autowired
  private VisitPlanOutletsClientInfoRepository visitPlanOutletsClientInfoRepository;

  @Transactional
  @Override
  public void createBatch(Set<VisitPlanOutletsClientInfo> visitPlanOutletsClientInfos) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanOutletsClientInfos), "批量新增数据时，入参集合不能为空！");
    visitPlanOutletsClientInfos.stream().forEach(visitPlanOutletsClientInfo -> this.createValidate(visitPlanOutletsClientInfo));
    this.visitPlanOutletsClientInfoRepository.saveBatch(visitPlanOutletsClientInfos);
  }

  @Transactional
  @Override
  public void deleteByRangeId(String rangeId) {
    this.visitPlanOutletsClientInfoRepository.deleteByRangeId(rangeId);
  }

  @Override
  public List<VisitPlanOutletsClientInfo> findByRangeId(String rangId) {
    if (StringUtils.isBlank(rangId)) {
      return new ArrayList<>(0);
    }
    return this.visitPlanOutletsClientInfoRepository.findByRangeId(rangId);
  }

  @Override
  public Map<String, List<VisitPlanOutletsClientInfo>> findByRangeIds(List<String> rangeIds) {
    if (CollectionUtils.isEmpty(rangeIds)) {
      return new HashMap<>(0);
    }
    List<VisitPlanOutletsClientInfo> list = this.visitPlanOutletsClientInfoRepository.findByRangeIds(rangeIds);
    if (CollectionUtils.isEmpty(list)) {
      return new HashMap<>(0);
    }
    return list.stream().collect(Collectors.groupingBy(VisitPlanOutletsClientInfo::getRangeId));
  }

  /**
   * 创建验证
   *
   * @param visitPlanOutletsClientInfo
   */
  private void createValidate(VisitPlanOutletsClientInfo visitPlanOutletsClientInfo) {
    Validate.notNull(visitPlanOutletsClientInfo, "新增时，对象信息不能为空！");
    visitPlanOutletsClientInfo.setId(null);
    Validate.notBlank(visitPlanOutletsClientInfo.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notBlank(visitPlanOutletsClientInfo.getClientType(), "新增数据时，客户类型不能为空！");
    Validate.notBlank(visitPlanOutletsClientInfo.getRangeId(), "新增数据时，网点拜访信息id不能为空！");

  }

}

