package com.biz.crm.sfa.business.visit.plan.outlets.local.service.internal;


import cn.hutool.core.bean.BeanUtil;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsRange;
import com.biz.crm.sfa.business.visit.plan.outlets.local.repository.VisitPlanOutletsRangeRepository;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsClientInfoService;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsRangeService;
import com.biz.crm.sfa.business.visit.plan.outlets.sdk.vo.VisitPlanOutletsClientInfoVo;
import com.biz.crm.sfa.business.visit.plan.outlets.sdk.vo.VisitPlanOutletsRouteRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 网点拜访信息表(VisitPlanOutletsRange)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
@Service("visitPlanOutletsRangeService")
public class VisitPlanOutletsRangeServiceImpl implements VisitPlanOutletsRangeService {

  @Autowired
  private VisitPlanOutletsRangeRepository visitPlanOutletsRangeRepository;

  @Autowired
  private VisitPlanOutletsClientInfoService visitPlanOutletsClientInfoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private List<ClientRouteStrategy> visitPlanClientRouteStrategies;

  /**
   * 新增数据
   *
   * @param visitPlanOutletsRange 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public VisitPlanOutletsRange create(VisitPlanOutletsRange visitPlanOutletsRange) {
    this.createValidate(visitPlanOutletsRange);
    this.visitPlanOutletsRangeRepository.saveOrUpdate(visitPlanOutletsRange);
    //保存关联客户表
    Set<VisitPlanOutletsClientInfo> visitPlanOutletsClientInfos = visitPlanOutletsRange.getClientInfos();
    visitPlanOutletsClientInfos.stream().forEach(visitPlanOutletsClientInfo -> visitPlanOutletsClientInfo.setRangeId(visitPlanOutletsRange.getId()));
    this.visitPlanOutletsClientInfoService.createBatch(visitPlanOutletsClientInfos);
    return visitPlanOutletsRange;
  }

  @Transactional
  @Override
  public VisitPlanOutletsRange update(VisitPlanOutletsRange visitPlanOutletsRange) {
    Validate.notNull(visitPlanOutletsRange, "修改时，网点维度信息不能为空！");
    //删除数据
    VisitPlanOutletsRange planOutletsRange = this.visitPlanOutletsRangeRepository.findByVisitPlanCode(visitPlanOutletsRange.getVisitPlanCode());
    if (planOutletsRange != null) {
      try {
        String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
        Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
        Validate.isTrue(visitPlanOutletsRange.getLoopsEndDate().after(nowDate), "修改时，循环结束时间小于当前时间不允许修改！");
      } catch (ParseException e) {
        e.printStackTrace();
      }
      this.visitPlanOutletsClientInfoService.deleteByRangeId(planOutletsRange.getId());
      this.visitPlanOutletsRangeRepository.deleteByVisitPlanCode(planOutletsRange.getVisitPlanCode());
    }
    //新增数据
    this.create(visitPlanOutletsRange);
    return visitPlanOutletsRange;
  }

  @Override
  public VisitPlanOutletsRouteRangeVo findByVisitPlanCode(String visitPlanCode) {
    if (StringUtils.isBlank(visitPlanCode)) {
      return null;
    }
    VisitPlanOutletsRange visitPlanOutletsRange = this.visitPlanOutletsRangeRepository.findByVisitPlanCode(visitPlanCode);
    if (visitPlanOutletsRange == null) {
      return null;
    }
    VisitPlanOutletsRouteRangeVo visitPlanOutletsRouteRangeVo = this.nebulaToolkitService.copyObjectByBlankList(visitPlanOutletsRange, VisitPlanOutletsRouteRangeVo.class, HashSet.class, ArrayList.class);
    List<VisitPlanOutletsClientInfo> clientInfos = this.visitPlanOutletsClientInfoService.findByRangeId(visitPlanOutletsRange.getId());
    List<VisitPlanOutletsClientInfoVo> visitPlanOutletsClientInfoVos = this.buildVisitPlanOutletsClientInfoVo(clientInfos);
    visitPlanOutletsRouteRangeVo.setClientInfos(visitPlanOutletsClientInfoVos);
    return visitPlanOutletsRouteRangeVo;
  }

  @Override
  public List<VisitPlanOutletsRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
    if (CollectionUtils.isEmpty(visitPlanCodes)) {
      return new ArrayList<>(0);
    }
    return this.visitPlanOutletsRangeRepository.findByVisitPlanCodes(visitPlanCodes);
  }

  /**
   * 组装客户信息数据
   *
   * @param clientInfos
   * @return
   */
  private List<VisitPlanOutletsClientInfoVo> buildVisitPlanOutletsClientInfoVo(List<VisitPlanOutletsClientInfo> clientInfos) {
    if (CollectionUtils.isEmpty(clientInfos)) {
      return new ArrayList<>(0);
    }
    //Map<clientRoute, Map<clientType, List<clientCode>>>
    Map<String, Map<String, List<String>>> clientMap = clientInfos.stream()
        .collect(
            Collectors.groupingBy(VisitPlanOutletsClientInfo::getClientRoute,
                Collectors.groupingBy(VisitPlanOutletsClientInfo::getClientType, Collectors.mapping(VisitPlanOutletsClientInfo::getClientCode, Collectors.toList())
                )));
    //判断客户维度策略
    Map<String, List<ClientRouteInfoVo>> infoVoHashMap = new HashMap<>();
    if (!CollectionUtils.isEmpty(visitPlanClientRouteStrategies)) {
      List<ClientRouteInfoVo> infoVos = new ArrayList<>();
      for (ClientRouteStrategy clientRouteStrategy : visitPlanClientRouteStrategies) {
        Map<String, List<String>> listMap = clientMap.get(clientRouteStrategy.getKey());
        if (listMap != null) {
          List<ClientRouteInfoVo> terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
          List<ClientRouteInfoVo> dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
          infoVos.addAll(terminalVos);
          infoVos.addAll(dealerVos);
        }
      }
      if (!CollectionUtils.isEmpty(infoVos)) {
        infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith("_", o.getClientRoute(), o.getClientType(), o.getClientCode())));
      }
    }
    //循环赋值
    ArrayList<VisitPlanOutletsClientInfoVo> visitPlanOutletsClientInfoVos = new ArrayList<>();
    for (VisitPlanOutletsClientInfo visitPlanOutletsClientInfo : clientInfos) {
      VisitPlanOutletsClientInfoVo visitPlanOutletsClientInfoVo = this.nebulaToolkitService.copyObjectByBlankList(visitPlanOutletsClientInfo, VisitPlanOutletsClientInfoVo.class, HashSet.class, ArrayList.class);
      visitPlanOutletsClientInfoVos.add(visitPlanOutletsClientInfoVo);
      String key = StringUtils.joinWith("_", visitPlanOutletsClientInfoVo.getClientRoute(), visitPlanOutletsClientInfoVo.getClientType(), visitPlanOutletsClientInfoVo.getClientCode());
      List<ClientRouteInfoVo> infoVos = infoVoHashMap.get(key);
      if (CollectionUtils.isEmpty(infoVos)) {
        continue;
      }
      ClientRouteInfoVo vo = infoVos.get(0);
      BeanUtil.copyProperties(vo, visitPlanOutletsClientInfoVo);
      visitPlanOutletsClientInfoVo.setAddress(vo.getClientAddress());
    }
    return visitPlanOutletsClientInfoVos;
  }

  /**
   * 创建验证
   *
   * @param visitPlanOutletsRange
   */
  private void createValidate(VisitPlanOutletsRange visitPlanOutletsRange) {
    Validate.notNull(visitPlanOutletsRange, "新增时，对象信息不能为空！");
    visitPlanOutletsRange.setId(null);
    Validate.notNull(visitPlanOutletsRange.getLoopsEndDate(), "新增数据时，循环结束日期不能为空！");
    Validate.notNull(visitPlanOutletsRange.getLoopsStartDate(), "新增数据时，循环开始日期不能为空！");
    Validate.notBlank(visitPlanOutletsRange.getVisitPlanCode(), "新增数据时，拜访计划编码不能为空！");
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanOutletsRange.getClientInfos()), "新增数据时，网点客户信息不能为空！");
    try {
      String nowDateStr = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
      Date nowDate = DateUtils.parseDate(nowDateStr, "yyyy-MM-dd");
      Validate.isTrue(visitPlanOutletsRange.getLoopsStartDate().compareTo(nowDate) >= 0, "循环开始日期必须大于或者等于当前日期！");
      Validate.isTrue(visitPlanOutletsRange.getLoopsEndDate().compareTo(visitPlanOutletsRange.getLoopsStartDate()) >= 0, "循环开始日期必须小于或者等于循环结束日期！");
    } catch (ParseException e) {
      e.printStackTrace();
    }
  }

}

