package com.biz.crm.sfa.business.visit.plan.outlets.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsRange;
import com.biz.crm.sfa.business.visit.plan.outlets.local.register.VisitPlanOutletsRouteRegister;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.constant.VisitPlanConstant;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanRouteRangeModel;
import com.biz.crm.sfa.business.visit.plan.sdk.strategy.VisitPlanRouteStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 网点维度观察者实现类
 *
 * @author songjingen
 */
@Component
public class VisitPlanOutletsRouteStrategy implements VisitPlanRouteStrategy {

  @Autowired
  private VisitPlanOutletsRouteRegister visitPlanOutletsRouteRegister;

  @Autowired
  private VisitPlanOutletsRangeService visitPlanOutletsRangeService;

  @Override
  public String getKey() {
    return this.visitPlanOutletsRouteRegister.getKey();
  }

  @Override
  public VisitPlanRouteRangeModel onCreate(JSONObject jsonObject) {
    JSONObject jsonOutletsObject = jsonObject.getJSONObject(this.getKey());
    Validate.notNull(jsonOutletsObject, "创建维度信息时，网点维度拜访信息不能为空！");
    String visitPlanCode = jsonObject.getString(VisitPlanConstant.VISIT_PLAN_CODE_FLAG);
    Validate.notBlank(visitPlanCode, "创建维度信息时，拜访计划编码不能为空！");
    VisitPlanOutletsRange visitPlanOutletsRange = JsonUtils.json2Obj(jsonOutletsObject.toJSONString(), VisitPlanOutletsRange.class);
    visitPlanOutletsRange.setVisitPlanCode(visitPlanCode);
    this.visitPlanOutletsRangeService.create(visitPlanOutletsRange);
    return this.buildVisitPlanRouteRangeModel(visitPlanOutletsRange);
  }

  @Override
  public VisitPlanRouteRangeModel onUpdate(JSONObject jsonObject) {
    JSONObject jsonOutletsObject = jsonObject.getJSONObject(this.getKey());
    Validate.notNull(jsonOutletsObject, "修改维度信息时，线路组维度拜访信息不能为空！");
    String visitPlanCode = jsonObject.getString(VisitPlanConstant.VISIT_PLAN_CODE_FLAG);
    Validate.notBlank(visitPlanCode, "创建维度信息时，拜访计划编码不能为空！");
    VisitPlanOutletsRange visitPlanOutletsRange = JsonUtils.json2Obj(jsonOutletsObject.toJSONString(), VisitPlanOutletsRange.class);
    visitPlanOutletsRange.setVisitPlanCode(visitPlanCode);
    this.visitPlanOutletsRangeService.update(visitPlanOutletsRange);
    return this.buildVisitPlanRouteRangeModel(visitPlanOutletsRange);
  }

  /**
   * 根据拜访计划编码查询数据
   *
   * @param visitPlanCode 拜访计划编码
   * @return 拜访计划维度拜访信息
   */
  @Override
  public VisitPlanRouteRangeAbstract onFindRouteRange(String visitPlanCode) {
    if (StringUtils.isAnyBlank(visitPlanCode)) {
      return null;
    }
    return this.visitPlanOutletsRangeService.findByVisitPlanCode(visitPlanCode);
  }

  /**
   * 构建返回model
   *
   * @param visitPlanLineRange
   */
  private VisitPlanRouteRangeModel buildVisitPlanRouteRangeModel(VisitPlanOutletsRange visitPlanLineRange) {
    if (visitPlanLineRange == null) {
      return null;
    }
    VisitPlanRouteRangeModel visitPlanRouteRangeModel = new VisitPlanRouteRangeModel();
    visitPlanRouteRangeModel.setVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
    visitPlanRouteRangeModel.setStartDate(visitPlanLineRange.getLoopsStartDate());
    visitPlanRouteRangeModel.setEndDate(visitPlanLineRange.getLoopsEndDate());
    return visitPlanRouteRangeModel;
  }
}
