/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.outlets.local.observer;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsRange;
import com.biz.crm.sfa.business.visit.plan.outlets.local.register.VisitPlanOutletsRouteRegister;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsClientInfoService;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class VisitPlanDetailOutletsObserver
implements VisitPlanDetailObserver {
    @Autowired
    private VisitPlanOutletsRouteRegister visitPlanOutletsRouteRegister;
    @Autowired
    private VisitPlanOutletsRangeService visitPlanOutletsRangeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VisitPlanDetailVoService visitPlanDetailVoService;
    @Autowired
    private VisitPlanOutletsClientInfoService visitPlanOutletsClientInfoService;

    public List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map) {
        if (map == null) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<String> visitPlanCodes = map.get(this.visitPlanOutletsRouteRegister.getKey());
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<VisitPlanOutletsRange> visitPlanLineRanges = this.visitPlanOutletsRangeService.findByVisitPlanCodes(visitPlanCodes);
        if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<String> rangeIds = visitPlanLineRanges.stream().map(UuidEntity::getId).collect(Collectors.toList());
        SimpleDateFormat weekSdf = new SimpleDateFormat("EE", Locale.CHINA);
        ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<VisitPlanDetailModel>();
        Map<String, List<VisitPlanOutletsClientInfo>> clientInfoMap = this.visitPlanOutletsClientInfoService.findByRangeIds(rangeIds);
        for (VisitPlanOutletsRange range : visitPlanLineRanges) {
            List<VisitPlanOutletsClientInfo> visitPlanLineRangeClientInfoVos = clientInfoMap.get(range.getId());
            if (CollectionUtils.isEmpty(visitPlanLineRangeClientInfoVos)) continue;
            String notWeekSet = range.getNotWeekSet();
            List weekValues = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)notWeekSet)) {
                Object[] split = notWeekSet.split(",");
                weekValues = VisitWeekTypeEnum.getValuesByDictCodes((List)Lists.newArrayList((Object[])split));
            }
            int dayDiffer = this.getDayDiffer(range.getLoopsStartDate(), range.getLoopsEndDate());
            for (int i = 0; i < dayDiffer; ++i) {
                Date visitDate = DateUtils.addDays((Date)range.getLoopsStartDate(), (int)i);
                String week = weekSdf.format(visitDate);
                if (weekValues.contains(week)) continue;
                List models = (List)this.nebulaToolkitService.copyCollectionByWhiteList(visitPlanLineRangeClientInfoVos, VisitPlanOutletsClientInfo.class, VisitPlanDetailModel.class, HashSet.class, ArrayList.class, new String[0]);
                models.stream().forEach(visitPlanDetailModel -> {
                    visitPlanDetailModel.setVisitPlanCode(range.getVisitPlanCode());
                    visitPlanDetailModel.setVisitDate(visitDate);
                    visitPlanDetailModel.setVisitStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
                });
                visitPlanDetailModels.addAll(models);
            }
        }
        return visitPlanDetailModels;
    }

    @Transactional
    public void onCreate(Map<String, List<String>> map) {
        List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
        if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
            this.visitPlanDetailVoService.createBatch(visitPlanDetailModels);
        }
    }

    @Transactional
    public void onUpdate(Map<String, List<String>> map) {
        List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
        if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
            this.visitPlanDetailVoService.updateBatch(visitPlanDetailModels);
        }
    }

    private int getDayDiffer(Date startDate, Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        long startDateTime = 0L;
        long endDateTime = 0L;
        try {
            startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
            endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return (int)((endDateTime - startDateTime) / 86400000L) + 1;
    }
}

