/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.outlets.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsClientInfo;
import com.biz.crm.sfa.business.visit.plan.outlets.local.entity.VisitPlanOutletsRange;
import com.biz.crm.sfa.business.visit.plan.outlets.local.repository.VisitPlanOutletsRangeRepository;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsClientInfoService;
import com.biz.crm.sfa.business.visit.plan.outlets.local.service.VisitPlanOutletsRangeService;
import com.biz.crm.sfa.business.visit.plan.outlets.sdk.vo.VisitPlanOutletsClientInfoVo;
import com.biz.crm.sfa.business.visit.plan.outlets.sdk.vo.VisitPlanOutletsRouteRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanOutletsRangeService")
public class VisitPlanOutletsRangeServiceImpl
implements VisitPlanOutletsRangeService {
    @Autowired
    private VisitPlanOutletsRangeRepository visitPlanOutletsRangeRepository;
    @Autowired
    private VisitPlanOutletsClientInfoService visitPlanOutletsClientInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<ClientRouteStrategy> visitPlanClientRouteStrategies;

    @Override
    @Transactional
    public VisitPlanOutletsRange create(VisitPlanOutletsRange visitPlanOutletsRange) {
        this.createValidate(visitPlanOutletsRange);
        this.visitPlanOutletsRangeRepository.saveOrUpdate((Object)visitPlanOutletsRange);
        Set<VisitPlanOutletsClientInfo> visitPlanOutletsClientInfos = visitPlanOutletsRange.getClientInfos();
        visitPlanOutletsClientInfos.stream().forEach(visitPlanOutletsClientInfo -> visitPlanOutletsClientInfo.setRangeId(visitPlanOutletsRange.getId()));
        this.visitPlanOutletsClientInfoService.createBatch(visitPlanOutletsClientInfos);
        return visitPlanOutletsRange;
    }

    @Override
    @Transactional
    public VisitPlanOutletsRange update(VisitPlanOutletsRange visitPlanOutletsRange) {
        Validate.notNull((Object)((Object)visitPlanOutletsRange), (String)"\u4fee\u6539\u65f6\uff0c\u7f51\u70b9\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlanOutletsRange planOutletsRange = this.visitPlanOutletsRangeRepository.findByVisitPlanCode(visitPlanOutletsRange.getVisitPlanCode());
        if (planOutletsRange != null) {
            try {
                String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
                Validate.isTrue((boolean)visitPlanOutletsRange.getLoopsEndDate().after(nowDate), (String)"\u4fee\u6539\u65f6\uff0c\u5faa\u73af\u7ed3\u675f\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (Object[])new Object[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.visitPlanOutletsClientInfoService.deleteByRangeId(planOutletsRange.getId());
            this.visitPlanOutletsRangeRepository.deleteByVisitPlanCode(planOutletsRange.getVisitPlanCode());
        }
        this.create(visitPlanOutletsRange);
        return visitPlanOutletsRange;
    }

    @Override
    public VisitPlanOutletsRouteRangeVo findByVisitPlanCode(String visitPlanCode) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode)) {
            return null;
        }
        VisitPlanOutletsRange visitPlanOutletsRange = this.visitPlanOutletsRangeRepository.findByVisitPlanCode(visitPlanCode);
        if (visitPlanOutletsRange == null) {
            return null;
        }
        VisitPlanOutletsRouteRangeVo visitPlanOutletsRouteRangeVo = (VisitPlanOutletsRouteRangeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanOutletsRange, VisitPlanOutletsRouteRangeVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<VisitPlanOutletsClientInfo> clientInfos = this.visitPlanOutletsClientInfoService.findByRangeId(visitPlanOutletsRange.getId());
        List<VisitPlanOutletsClientInfoVo> visitPlanOutletsClientInfoVos = this.buildVisitPlanOutletsClientInfoVo(clientInfos);
        visitPlanOutletsRouteRangeVo.setClientInfos(visitPlanOutletsClientInfoVos);
        return visitPlanOutletsRouteRangeVo;
    }

    @Override
    public List<VisitPlanOutletsRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return new ArrayList<VisitPlanOutletsRange>(0);
        }
        return this.visitPlanOutletsRangeRepository.findByVisitPlanCodes(visitPlanCodes);
    }

    private List<VisitPlanOutletsClientInfoVo> buildVisitPlanOutletsClientInfoVo(List<VisitPlanOutletsClientInfo> clientInfos) {
        if (CollectionUtils.isEmpty(clientInfos)) {
            return new ArrayList<VisitPlanOutletsClientInfoVo>(0);
        }
        Map clientMap = clientInfos.stream().collect(Collectors.groupingBy(VisitPlanOutletsClientInfo::getClientRoute, Collectors.groupingBy(VisitPlanOutletsClientInfo::getClientType, Collectors.mapping(VisitPlanOutletsClientInfo::getClientCode, Collectors.toList()))));
        Map<Object, Object> infoVoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(this.visitPlanClientRouteStrategies)) {
            ArrayList infoVos = new ArrayList();
            for (ClientRouteStrategy clientRouteStrategy : this.visitPlanClientRouteStrategies) {
                Map listMap = clientMap.get(clientRouteStrategy.getKey());
                if (listMap == null) continue;
                List terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
                List dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
                infoVos.addAll(terminalVos);
                infoVos.addAll(dealerVos);
            }
            if (!CollectionUtils.isEmpty(infoVos)) {
                infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"_", (Object[])new Object[]{o.getClientRoute(), o.getClientType(), o.getClientCode()})));
            }
        }
        ArrayList<VisitPlanOutletsClientInfoVo> visitPlanOutletsClientInfoVos = new ArrayList<VisitPlanOutletsClientInfoVo>();
        for (VisitPlanOutletsClientInfo visitPlanOutletsClientInfo : clientInfos) {
            VisitPlanOutletsClientInfoVo visitPlanOutletsClientInfoVo = (VisitPlanOutletsClientInfoVo)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanOutletsClientInfo, VisitPlanOutletsClientInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            visitPlanOutletsClientInfoVos.add(visitPlanOutletsClientInfoVo);
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{visitPlanOutletsClientInfoVo.getClientRoute(), visitPlanOutletsClientInfoVo.getClientType(), visitPlanOutletsClientInfoVo.getClientCode()});
            List infoVos = (List)infoVoHashMap.get(key);
            if (CollectionUtils.isEmpty((Collection)infoVos)) continue;
            ClientRouteInfoVo vo = (ClientRouteInfoVo)infoVos.get(0);
            BeanUtil.copyProperties((Object)vo, (Object)visitPlanOutletsClientInfoVo, (String[])new String[0]);
            visitPlanOutletsClientInfoVo.setAddress(vo.getClientAddress());
        }
        return visitPlanOutletsClientInfoVos;
    }

    private void createValidate(VisitPlanOutletsRange visitPlanOutletsRange) {
        Validate.notNull((Object)((Object)visitPlanOutletsRange), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanOutletsRange.setId(null);
        Validate.notNull((Object)visitPlanOutletsRange.getLoopsEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5faa\u73af\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)visitPlanOutletsRange.getLoopsStartDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanOutletsRange.getVisitPlanCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(visitPlanOutletsRange.getClientInfos()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7f51\u70b9\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
            Validate.isTrue((visitPlanOutletsRange.getLoopsStartDate().compareTo(nowDate) >= 0 ? 1 : 0) != 0, (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff01", (Object[])new Object[0]);
            Validate.isTrue((visitPlanOutletsRange.getLoopsEndDate().compareTo(visitPlanOutletsRange.getLoopsStartDate()) >= 0 ? 1 : 0) != 0, (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6216\u8005\u7b49\u4e8e\u5faa\u73af\u7ed3\u675f\u65e5\u671f\uff01", (Object[])new Object[0]);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

