package com.biz.crm.sfa.business.visit.plan.outlets.sdk.vo;

import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Entity;
import java.util.List;

/**
 * 网点维度客户信息Vo
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanOutletsClientInfoVo", description = "网点维度客户信息Vo")
public class VisitPlanOutletsClientInfoVo {

  private static final long serialVersionUID = 8840715398460223044L;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 客户细类名称
   */
  @ApiModelProperty("客户细类名称")
  private String clientSubName;

  /**
   * 联系人列表
   */
  @ApiModelProperty("联系人列表")
  private List<ClientContactVo> contactList;

  /**
   * 客户地址
   */
  @ApiModelProperty("客户地址")
  private String address;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  private String clientRoute;

}
