/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.rate.local.service.internal;

import cn.hutool.core.bean.BeanUtil;
import com.biz.crm.sfa.business.client.sdk.enums.ClientTypeEnum;
import com.biz.crm.sfa.business.client.sdk.strategy.ClientRouteStrategy;
import com.biz.crm.sfa.business.client.sdk.vo.ClientRouteInfoVo;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateClientInfo;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateRange;
import com.biz.crm.sfa.business.visit.plan.rate.local.repository.VisitPlanRateRangeRepository;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateClientInfoService;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateRangeService;
import com.biz.crm.sfa.business.visit.plan.rate.sdk.vo.VisitPlanRateClientInfoVo;
import com.biz.crm.sfa.business.visit.plan.rate.sdk.vo.VisitPlanRateRouteRangeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="visitPlanRateRangeService")
public class VisitPlanRateRangeServiceImpl
implements VisitPlanRateRangeService {
    @Autowired
    private VisitPlanRateRangeRepository visitPlanRateRangeRepository;
    @Autowired
    private VisitPlanRateClientInfoService visitPlanRateClientInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<ClientRouteStrategy> visitPlanClientRouteStrategies;

    @Override
    @Transactional
    public VisitPlanRateRange create(VisitPlanRateRange visitPlanRateRange) {
        this.createValidate(visitPlanRateRange);
        this.visitPlanRateRangeRepository.saveOrUpdate((Object)visitPlanRateRange);
        Set<VisitPlanRateClientInfo> visitPlanOutletsClientInfos = visitPlanRateRange.getClientInfos();
        visitPlanOutletsClientInfos.stream().forEach(visitPlanOutletsClientInfo -> visitPlanOutletsClientInfo.setRangeId(visitPlanRateRange.getId()));
        this.visitPlanRateClientInfoService.createBatch(visitPlanOutletsClientInfos);
        return visitPlanRateRange;
    }

    @Override
    @Transactional
    public VisitPlanRateRange update(VisitPlanRateRange visitPlanRateRange) {
        Validate.notNull((Object)((Object)visitPlanRateRange), (String)"\u4fee\u6539\u65f6\uff0c\u9891\u7387\u7ef4\u5ea6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        VisitPlanRateRange planRateRange = this.visitPlanRateRangeRepository.findByVisitPlanCode(visitPlanRateRange.getVisitPlanCode());
        if (planRateRange != null) {
            try {
                String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
                Validate.isTrue((boolean)visitPlanRateRange.getLoopsEndDate().after(nowDate), (String)"\u4fee\u6539\u65f6\uff0c\u5faa\u73af\u7ed3\u675f\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\u4e0d\u5141\u8bb8\u4fee\u6539\uff01", (Object[])new Object[0]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.visitPlanRateClientInfoService.deleteByRangeId(planRateRange.getId());
            this.visitPlanRateRangeRepository.deleteByVisitPlanCode(planRateRange.getVisitPlanCode());
        }
        this.create(visitPlanRateRange);
        return visitPlanRateRange;
    }

    @Override
    public VisitPlanRateRouteRangeVo findByVisitPlanCode(String visitPlanCode) {
        if (StringUtils.isBlank((CharSequence)visitPlanCode)) {
            return null;
        }
        VisitPlanRateRange visitPlanRateRange = this.visitPlanRateRangeRepository.findByVisitPlanCode(visitPlanCode);
        if (visitPlanRateRange == null) {
            return null;
        }
        VisitPlanRateRouteRangeVo visitPlanRateRouteRangeVo = (VisitPlanRateRouteRangeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanRateRange, VisitPlanRateRouteRangeVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<VisitPlanRateClientInfo> clientInfos = this.visitPlanRateClientInfoService.findByRangeId(visitPlanRateRange.getId());
        List<VisitPlanRateClientInfoVo> visitPlanRateClientInfoVos = this.buildVisitPlanRateClientInfoVo(clientInfos);
        visitPlanRateRouteRangeVo.setClientInfos(visitPlanRateClientInfoVos);
        return visitPlanRateRouteRangeVo;
    }

    @Override
    public List<VisitPlanRateRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return new ArrayList<VisitPlanRateRange>(0);
        }
        return this.visitPlanRateRangeRepository.findByVisitPlanCodes(visitPlanCodes);
    }

    private List<VisitPlanRateClientInfoVo> buildVisitPlanRateClientInfoVo(List<VisitPlanRateClientInfo> clientInfos) {
        if (CollectionUtils.isEmpty(clientInfos)) {
            return new ArrayList<VisitPlanRateClientInfoVo>(0);
        }
        Map clientMap = clientInfos.stream().collect(Collectors.groupingBy(VisitPlanRateClientInfo::getClientRoute, Collectors.groupingBy(VisitPlanRateClientInfo::getClientType, Collectors.mapping(VisitPlanRateClientInfo::getClientCode, Collectors.toList()))));
        Map<Object, Object> infoVoHashMap = new HashMap();
        if (!CollectionUtils.isEmpty(this.visitPlanClientRouteStrategies)) {
            ArrayList infoVos = new ArrayList();
            for (ClientRouteStrategy clientRouteStrategy : this.visitPlanClientRouteStrategies) {
                Map listMap = clientMap.get(clientRouteStrategy.getKey());
                if (listMap == null) continue;
                List terminalVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.TERMINAL.getDictCode()), ClientTypeEnum.TERMINAL.getDictCode());
                List dealerVos = clientRouteStrategy.onFindByClientCodesAndType(listMap.get(ClientTypeEnum.DEALER.getDictCode()), ClientTypeEnum.DEALER.getDictCode());
                infoVos.addAll(terminalVos);
                infoVos.addAll(dealerVos);
            }
            if (!CollectionUtils.isEmpty(infoVos)) {
                infoVoHashMap = infoVos.stream().collect(Collectors.groupingBy(o -> StringUtils.joinWith((String)"_", (Object[])new Object[]{o.getClientRoute(), o.getClientType(), o.getClientCode()})));
            }
        }
        ArrayList<VisitPlanRateClientInfoVo> visitPlanRateClientInfoVos = new ArrayList<VisitPlanRateClientInfoVo>();
        for (VisitPlanRateClientInfo visitPlanRateClientInfo : clientInfos) {
            VisitPlanRateClientInfoVo visitPlanRateClientInfoVo = (VisitPlanRateClientInfoVo)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanRateClientInfo, VisitPlanRateClientInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            visitPlanRateClientInfoVos.add(visitPlanRateClientInfoVo);
            String key = StringUtils.joinWith((String)"_", (Object[])new Object[]{visitPlanRateClientInfo.getClientRoute(), visitPlanRateClientInfo.getClientType(), visitPlanRateClientInfo.getClientCode()});
            List infoVos = (List)infoVoHashMap.get(key);
            if (CollectionUtils.isEmpty((Collection)infoVos)) continue;
            ClientRouteInfoVo vo = (ClientRouteInfoVo)infoVos.get(0);
            BeanUtil.copyProperties((Object)vo, (Object)visitPlanRateClientInfoVo, (String[])new String[0]);
            visitPlanRateClientInfoVo.setAddress(vo.getClientAddress());
        }
        return visitPlanRateClientInfoVos;
    }

    private void createValidate(VisitPlanRateRange visitPlanRateRange) {
        Validate.notNull((Object)((Object)visitPlanRateRange), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        visitPlanRateRange.setId(null);
        Date loopsEndDate = visitPlanRateRange.getLoopsEndDate();
        Date loopsStartDate = visitPlanRateRange.getLoopsStartDate();
        Set<VisitPlanRateClientInfo> clientInfos = visitPlanRateRange.getClientInfos();
        Validate.notNull((Object)loopsEndDate, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5faa\u73af\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)loopsStartDate, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)visitPlanRateRange.getVisitPlanCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u62dc\u8bbf\u8ba1\u5212\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(clientInfos) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9891\u7387\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            String nowDateStr = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            Date nowDate = DateUtils.parseDate((String)nowDateStr, (String[])new String[]{"yyyy-MM-dd"});
            Validate.isTrue((visitPlanRateRange.getLoopsStartDate().compareTo(nowDate) >= 0 ? 1 : 0) != 0, (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u6216\u8005\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff01", (Object[])new Object[0]);
            Validate.isTrue((visitPlanRateRange.getLoopsEndDate().compareTo(visitPlanRateRange.getLoopsStartDate()) >= 0 ? 1 : 0) != 0, (String)"\u5faa\u73af\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u6216\u8005\u7b49\u4e8e\u5faa\u73af\u7ed3\u675f\u65e5\u671f\uff01", (Object[])new Object[0]);
            clientInfos.stream().forEach(visitPlanRateClientInfo -> {
                Date firstVisitDate = visitPlanRateClientInfo.getFirstVisitDate();
                Validate.isTrue((firstVisitDate.compareTo(loopsStartDate) >= 0 && firstVisitDate.compareTo(loopsEndDate) <= 0 ? 1 : 0) != 0, (String)"\u9996\u6b21\u62dc\u8bbf\u65e5\u671f\u5fc5\u987b\u5728\u5faa\u73af\u65e5\u671f\u5185\uff01", (Object[])new Object[0]);
            });
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

