package com.biz.crm.sfa.business.visit.plan.rate.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.client.sdk.register.ClientRouteRegister;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * 频率维度客户信息 实体类
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("sfa_visit_plan_rate_client_info")
@Table(name = "sfa_visit_plan_rate_client_info")
@ApiModel(value = "VisitPlanRateClientInfo", description = "频率维度客户信息表")
@org.hibernate.annotations.Table(appliesTo = "sfa_visit_plan_rate_client_info", comment = "频率维度客户信息表")
public class VisitPlanRateClientInfo extends UuidEntity {

  private static final long serialVersionUID = 8840715398460223044L;
  /**
   * 频率拜访信息id
   */
  @ApiModelProperty("频率拜访信息id")
  @Column(name = "range_id", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '频率拜访信息id'")
  private String rangeId;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  @Column(name = "client_code", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户编码'")
  private String clientCode;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  @Column(name = "client_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '客户类型'")
  private String clientType;

  /**
   * 客户维度
   * {@link ClientRouteRegister#getKey()}
   */
  @ApiModelProperty("客户维度")
  @Column(name = "client_route", length = 255, nullable = false, columnDefinition = "varchar(64) COMMENT '客户维度'")
  private String clientRoute;

  /**
   * 首次拜访日期（yyyy-MM-dd）
   */
  @ApiModelProperty("首次拜访日期（yyyy-MM-dd）")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @Column(name = "first_visit_date", length = 20, nullable = false, columnDefinition = "date COMMENT '首次拜访日期'")
  private Date firstVisitDate;

  /**
   * 拜访频率（天/1次）
   */
  @ApiModelProperty("拜访频率（天/1次）")
  @Column(name = "visit_rate", length = 8, nullable = false, columnDefinition = "int(8) COMMENT '拜访频率（天/1次）'")
  private Integer visitRate;

}
