package com.biz.crm.sfa.business.visit.plan.rate.local.observer;

import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateClientInfo;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateRange;
import com.biz.crm.sfa.business.visit.plan.rate.local.register.VisitPlanRateRouteRegister;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateClientInfoService;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 拜访计划线路组观察者实现类
 *
 * @author songjingen
 */
@Component
public class VisitPlanDetailRateObserver implements VisitPlanDetailObserver {

  @Autowired
  private VisitPlanRateRouteRegister visitPlanRateRouteRegister;

  @Autowired
  private VisitPlanRateRangeService visitPlanRateRangeService;

  @Autowired
  private VisitPlanRateClientInfoService visitPlanRateClientInfoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired
  private VisitPlanDetailVoService visitPlanDetailVoService;

  @Override
  public List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map) {
    if (map == null) {
      return new ArrayList<>(0);
    }
    List<String> visitPlanCodes = map.get(visitPlanRateRouteRegister.getKey());
    if (CollectionUtils.isEmpty(visitPlanCodes)) {
      return new ArrayList<>(0);
    }
    List<VisitPlanRateRange> visitPlanLineRanges = this.visitPlanRateRangeService.findByVisitPlanCodes(visitPlanCodes);
    if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
      return new ArrayList<>(0);
    }
    List<String> rangeIds = visitPlanLineRanges.stream().map(VisitPlanRateRange::getId).collect(Collectors.toList());
    //按照rangeId分组后的map
    SimpleDateFormat weekSdf = new SimpleDateFormat("EE", Locale.CHINA);
    List<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<>();
    Map<String, List<VisitPlanRateClientInfo>> clientInfoMap = this.visitPlanRateClientInfoService.findByRangeIds(rangeIds);
    for (VisitPlanRateRange range : visitPlanLineRanges) {
      List<VisitPlanRateClientInfo> visitPlanLineRangeClientInfoVos = clientInfoMap.get(range.getId());
      if (CollectionUtils.isEmpty(visitPlanLineRangeClientInfoVos)) {
        continue;
      }
      String notWeekSet = range.getNotWeekSet();
      List<String> weekValues = new ArrayList<>();
      if (StringUtils.isNotBlank(notWeekSet)) {
        String[] split = notWeekSet.split(",");
        weekValues = VisitWeekTypeEnum.getValuesByDictCodes(Lists.newArrayList(split));
      }
      //循环客户信息，根据客户信息的首次时间和频率判断可以生成计划条数
      for (VisitPlanRateClientInfo visitPlanLineRangeClientInfoVo : visitPlanLineRangeClientInfoVos) {
        Date firstVisitDate = visitPlanLineRangeClientInfoVo.getFirstVisitDate();
        Integer visitRate = visitPlanLineRangeClientInfoVo.getVisitRate();
        //计算天数
        int dayDiffer = this.getDayDiffer(firstVisitDate, range.getLoopsEndDate());
        int count = dayDiffer / visitRate;
        for (int i = 0; i < count; i++) {
          Date visitDate = DateUtils.addDays(firstVisitDate, i * visitRate);
          //排除星期
          String week = weekSdf.format(visitDate);
          if (weekValues.contains(week)) {
            continue;
          }
          VisitPlanDetailModel visitPlanDetailModel = this.nebulaToolkitService.copyObjectByBlankList(visitPlanLineRangeClientInfoVo, VisitPlanDetailModel.class, HashSet.class, ArrayList.class);
          visitPlanDetailModel.setVisitPlanCode(range.getVisitPlanCode());
          visitPlanDetailModel.setVisitStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
          visitPlanDetailModel.setVisitDate(visitDate);
          visitPlanDetailModels.add(visitPlanDetailModel);
        }
      }
    }
    return visitPlanDetailModels;
  }

  @Override
  @Transactional
  public void onCreate(Map<String, List<String>> map) {
    List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
    if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
      this.visitPlanDetailVoService.createBatch(visitPlanDetailModels);
    }
  }

  @Transactional
  @Override
  public void onUpdate(Map<String, List<String>> map) {
    List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
    if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
      this.visitPlanDetailVoService.updateBatch(visitPlanDetailModels);
    }
  }

  /**
   * 计算开始时间，结束时间，间隔天数
   *
   * @param startDate
   * @param endDate
   * @return
   */
  private int getDayDiffer(Date startDate, Date endDate) {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    long startDateTime = 0;
    long endDateTime = 0;
    try {
      startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
      endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
    } catch (ParseException e) {
      e.printStackTrace();
    }
    return (int) ((endDateTime - startDateTime) / (1000 * 3600 * 24)) + 1;
  }

}
