package com.biz.crm.sfa.business.visit.plan.rate.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateClientInfo;
import com.biz.crm.sfa.business.visit.plan.rate.local.mapper.VisitPlanRateClientInfoMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 频率维度客户信息表(VisitPlanOutletsClientInfo)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
@Component
public class VisitPlanRateClientInfoRepository extends ServiceImpl<VisitPlanRateClientInfoMapper, VisitPlanRateClientInfo> {

  /**
   * 根据频率维度id删除数据
   *
   * @param rangeId
   */
  public void deleteByRangeId(String rangeId) {
    this.lambdaUpdate().eq(VisitPlanRateClientInfo::getRangeId, rangeId).remove();
  }

  /**
   * 根据频率维度id查询数据
   *
   * @param rangeId
   */
  public List<VisitPlanRateClientInfo> findByRangeId(String rangeId) {
    return this.lambdaQuery().eq(VisitPlanRateClientInfo::getRangeId, rangeId).list();
  }

  /**
   * 按照rangeId集合查询数据
   *
   * @param rangeIds
   * @return
   */
  public List<VisitPlanRateClientInfo> findByRangeIds(List<String> rangeIds) {
    return this.lambdaQuery().in(VisitPlanRateClientInfo::getRangeId, rangeIds).list();
  }
}

