package com.biz.crm.sfa.business.visit.plan.rate.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateRange;
import com.biz.crm.sfa.business.visit.plan.rate.local.mapper.VisitPlanRateRangeMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 频率拜访信息表(VisitPlanRateRange)表数据库访问层
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
@Component
public class VisitPlanRateRangeRepository extends ServiceImpl<VisitPlanRateRangeMapper, VisitPlanRateRange> {

  /**
   * 根据拜访计划编码删除数据
   *
   * @param visitPlanCode
   */
  public void deleteByVisitPlanCode(String visitPlanCode) {
    this.lambdaUpdate().eq(VisitPlanRateRange::getVisitPlanCode, visitPlanCode).remove();
  }

  /**
   * 根据拜访计划编码查询数据
   *
   * @param visitPlanCode
   */
  public VisitPlanRateRange findByVisitPlanCode(String visitPlanCode) {
    return this.lambdaQuery().eq(VisitPlanRateRange::getVisitPlanCode, visitPlanCode).one();
  }

  /**
   * 根据拜访计划编码集合查询数据
   *
   * @param visitPlanCodes
   * @return
   */
  public List<VisitPlanRateRange> findByVisitPlanCodes(List<String> visitPlanCodes) {
    return this.lambdaQuery().in(VisitPlanRateRange::getVisitPlanCode, visitPlanCodes).list();
  }
}

