package com.biz.crm.sfa.business.visit.plan.rate.local.service;


import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateClientInfo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 频率维度客户信息表(VisitPlanOutletsClientInfo)表服务接口
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
public interface VisitPlanRateClientInfoService {

  /**
   * 新增数据(批量)
   *
   * @param visitPlanOutletsClientInfos 实体对象
   * @return 新增结果
   */
  void createBatch(Set<VisitPlanRateClientInfo> visitPlanOutletsClientInfos);

  /**
   * 根据频率维度id删除数据
   *
   * @param rangId 频率维度id
   * @return 删除结果
   */
  void deleteByRangeId(String rangId);

  /**
   * 根据频率维度id查询数据
   *
   * @param rangId 频率维度id
   * @return 删除结果
   */
  List<VisitPlanRateClientInfo> findByRangeId(String rangId);

  /**
   * 按照rangeId分组查询数据
   *
   * @param rangeIds
   * @return
   */
  Map<String, List<VisitPlanRateClientInfo>> findByRangeIds(List<String> rangeIds);
}

