package com.biz.crm.sfa.business.visit.plan.rate.local.service;


import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateRange;
import com.biz.crm.sfa.business.visit.plan.rate.sdk.vo.VisitPlanRateRouteRangeVo;

import java.util.List;

/**
 * 频率拜访信息表(VisitPlanRateRange)表服务接口
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
public interface VisitPlanRateRangeService {

  /**
   * 新增数据
   *
   * @param visitPlanOutletsRange 实体对象
   * @return 新增结果
   */
  VisitPlanRateRange create(VisitPlanRateRange visitPlanOutletsRange);

  /**
   * 修改新据
   *
   * @param visitPlanLineRange 实体对象
   * @return 修改结果
   */
  VisitPlanRateRange update(VisitPlanRateRange visitPlanLineRange);


  /**
   * 根据拜访计划编码查询拜访信息
   *
   * @param visitPlanCode
   * @return 拜访信息
   */
  VisitPlanRateRouteRangeVo findByVisitPlanCode(String visitPlanCode);


  /**
   * 根据拜访计划编码集合查询拜访信息
   *
   * @param visitPlanCodes
   * @return
   */
  List<VisitPlanRateRange> findByVisitPlanCodes(List<String> visitPlanCodes);
}

