package com.biz.crm.sfa.business.visit.plan.rate.local.service.internal;


import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateClientInfo;
import com.biz.crm.sfa.business.visit.plan.rate.local.repository.VisitPlanRateClientInfoRepository;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateClientInfoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 频率维度客户信息表(VisitPlanOutletsClientInfo)表服务实现类
 *
 * @author songjingen
 * @since 2022-05-12 14:44:02
 */
@Service("visitPlanRateClientInfoService")
public class VisitPlanRateClientInfoServiceImpl implements VisitPlanRateClientInfoService {

  @Autowired
  private VisitPlanRateClientInfoRepository visitPlanRateClientInfoRepository;

  @Transactional
  @Override
  public void createBatch(Set<VisitPlanRateClientInfo> visitPlanRateClientInfos) {
    Validate.isTrue(!CollectionUtils.isEmpty(visitPlanRateClientInfos), "批量新增数据时，入参集合不能为空！");
    visitPlanRateClientInfos.stream().forEach(visitPlanOutletsClientInfo -> this.createValidate(visitPlanOutletsClientInfo));
    this.visitPlanRateClientInfoRepository.saveBatch(visitPlanRateClientInfos);
  }

  @Transactional
  @Override
  public void deleteByRangeId(String rangeId) {
    this.visitPlanRateClientInfoRepository.deleteByRangeId(rangeId);
  }

  @Override
  public List<VisitPlanRateClientInfo> findByRangeId(String rangId) {
    if (StringUtils.isBlank(rangId)) {
      return new ArrayList<>(0);
    }
    return this.visitPlanRateClientInfoRepository.findByRangeId(rangId);
  }

  @Override
  public Map<String, List<VisitPlanRateClientInfo>> findByRangeIds(List<String> rangeIds) {
    if (CollectionUtils.isEmpty(rangeIds)) {
      return new HashMap<>(0);
    }
    List<VisitPlanRateClientInfo> list = this.visitPlanRateClientInfoRepository.findByRangeIds(rangeIds);
    if (CollectionUtils.isEmpty(list)) {
      return new HashMap<>(0);
    }
    return list.stream().collect(Collectors.groupingBy(VisitPlanRateClientInfo::getRangeId));
  }

  /**
   * 创建验证
   *
   * @param visitPlanRateClientInfo
   */
  private void createValidate(VisitPlanRateClientInfo visitPlanRateClientInfo) {
    Validate.notNull(visitPlanRateClientInfo, "新增时，对象信息不能为空！");
    visitPlanRateClientInfo.setId(null);
    Validate.notBlank(visitPlanRateClientInfo.getClientCode(), "新增数据时，客户编码不能为空！");
    Validate.notBlank(visitPlanRateClientInfo.getClientType(), "新增数据时，客户类型不能为空！");
    Validate.notBlank(visitPlanRateClientInfo.getRangeId(), "新增数据时，频率拜访信息id不能为空！");
    Validate.notNull(visitPlanRateClientInfo.getFirstVisitDate(), "新增数据时，频率拜访信息首次拜访日期不能为空！");
    Validate.notNull(visitPlanRateClientInfo.getVisitRate(), "新增数据时，频率拜访信息拜访频率不能为空！");
    Validate.isTrue(visitPlanRateClientInfo.getVisitRate().compareTo(0) > 0, "新增数据时，频率拜访信息拜访频率必须大于0！");
  }

}

