package com.biz.crm.sfa.business.visit.plan.rate.local.strategy;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateRange;
import com.biz.crm.sfa.business.visit.plan.rate.local.register.VisitPlanRateRouteRegister;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.constant.VisitPlanConstant;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanRouteRangeModel;
import com.biz.crm.sfa.business.visit.plan.sdk.strategy.VisitPlanRouteStrategy;
import com.bizunited.nebula.common.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 网点维度观察者实现类
 *
 * @author songjingen
 */
@Component
public class VisitPlanRateRouteStrategy implements VisitPlanRouteStrategy {

  @Autowired
  private VisitPlanRateRouteRegister visitPlanRateRouteRegister;

  @Autowired
  private VisitPlanRateRangeService visitPlanRateRangeService;

  @Override
  public String getKey() {
    return this.visitPlanRateRouteRegister.getKey();
  }

  @Override
  public VisitPlanRouteRangeModel onCreate(JSONObject jsonObject) {
    JSONObject jsonRateObject = jsonObject.getJSONObject(this.getKey());
    Validate.notNull(jsonRateObject, "创建维度信息时，频率维度拜访信息不能为空！");
    String visitPlanCode = jsonObject.getString(VisitPlanConstant.VISIT_PLAN_CODE_FLAG);
    Validate.notBlank(visitPlanCode, "创建维度信息时，拜访计划编码不能为空！");
    VisitPlanRateRange visitPlanRateRange = JsonUtils.json2Obj(jsonRateObject.toJSONString(), VisitPlanRateRange.class);
    visitPlanRateRange.setVisitPlanCode(visitPlanCode);
    this.visitPlanRateRangeService.create(visitPlanRateRange);
    return this.buildVisitPlanRouteRangeModel(visitPlanRateRange);
  }

  @Override
  public VisitPlanRouteRangeModel onUpdate(JSONObject jsonObject) {
    JSONObject jsonRateObject = jsonObject.getJSONObject(this.getKey());
    Validate.notNull(jsonRateObject, "修改维度信息时，频率维度拜访信息不能为空！");
    String visitPlanCode = jsonObject.getString(VisitPlanConstant.VISIT_PLAN_CODE_FLAG);
    Validate.notBlank(visitPlanCode, "创建维度信息时，拜访计划编码不能为空！");
    VisitPlanRateRange visitPlanRateRange = JsonUtils.json2Obj(jsonRateObject.toJSONString(), VisitPlanRateRange.class);
    visitPlanRateRange.setVisitPlanCode(visitPlanCode);
    this.visitPlanRateRangeService.update(visitPlanRateRange);
    return this.buildVisitPlanRouteRangeModel(visitPlanRateRange);
  }

  /**
   * 根据拜访计划编码查询数据
   *
   * @param visitPlanCode 拜访计划编码
   * @return 拜访计划维度拜访信息
   */
  @Override
  public VisitPlanRouteRangeAbstract onFindRouteRange(String visitPlanCode) {
    if (StringUtils.isAnyBlank(visitPlanCode)) {
      return null;
    }
    return this.visitPlanRateRangeService.findByVisitPlanCode(visitPlanCode);
  }

  /**
   * 构建返回model
   *
   * @param visitPlanLineRange
   */
  private VisitPlanRouteRangeModel buildVisitPlanRouteRangeModel(VisitPlanRateRange visitPlanLineRange) {
    if (visitPlanLineRange == null) {
      return null;
    }
    VisitPlanRouteRangeModel visitPlanRouteRangeModel = new VisitPlanRouteRangeModel();
    visitPlanRouteRangeModel.setVisitPlanCode(visitPlanLineRange.getVisitPlanCode());
    visitPlanRouteRangeModel.setStartDate(visitPlanLineRange.getLoopsStartDate());
    visitPlanRouteRangeModel.setEndDate(visitPlanLineRange.getLoopsEndDate());
    return visitPlanRouteRangeModel;
  }
}
