/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.visit.plan.rate.local.observer;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateClientInfo;
import com.biz.crm.sfa.business.visit.plan.rate.local.entity.VisitPlanRateRange;
import com.biz.crm.sfa.business.visit.plan.rate.local.register.VisitPlanRateRouteRegister;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateClientInfoService;
import com.biz.crm.sfa.business.visit.plan.rate.local.service.VisitPlanRateRangeService;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitStatusEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.model.VisitPlanDetailModel;
import com.biz.crm.sfa.business.visit.plan.sdk.observer.VisitPlanDetailObserver;
import com.biz.crm.sfa.business.visit.plan.sdk.service.VisitPlanDetailVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class VisitPlanDetailRateObserver
implements VisitPlanDetailObserver {
    @Autowired
    private VisitPlanRateRouteRegister visitPlanRateRouteRegister;
    @Autowired
    private VisitPlanRateRangeService visitPlanRateRangeService;
    @Autowired
    private VisitPlanRateClientInfoService visitPlanRateClientInfoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VisitPlanDetailVoService visitPlanDetailVoService;

    public List<VisitPlanDetailModel> onRequestVisitDetailDto(Map<String, List<String>> map) {
        if (map == null) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<String> visitPlanCodes = map.get(this.visitPlanRateRouteRegister.getKey());
        if (CollectionUtils.isEmpty(visitPlanCodes)) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<VisitPlanRateRange> visitPlanLineRanges = this.visitPlanRateRangeService.findByVisitPlanCodes(visitPlanCodes);
        if (CollectionUtils.isEmpty(visitPlanLineRanges)) {
            return new ArrayList<VisitPlanDetailModel>(0);
        }
        List<String> rangeIds = visitPlanLineRanges.stream().map(UuidEntity::getId).collect(Collectors.toList());
        SimpleDateFormat weekSdf = new SimpleDateFormat("EE", Locale.CHINA);
        ArrayList<VisitPlanDetailModel> visitPlanDetailModels = new ArrayList<VisitPlanDetailModel>();
        Map<String, List<VisitPlanRateClientInfo>> clientInfoMap = this.visitPlanRateClientInfoService.findByRangeIds(rangeIds);
        for (VisitPlanRateRange range : visitPlanLineRanges) {
            List<VisitPlanRateClientInfo> visitPlanLineRangeClientInfoVos = clientInfoMap.get(range.getId());
            if (CollectionUtils.isEmpty(visitPlanLineRangeClientInfoVos)) continue;
            String notWeekSet = range.getNotWeekSet();
            List weekValues = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)notWeekSet)) {
                Object[] split = notWeekSet.split(",");
                weekValues = VisitWeekTypeEnum.getValuesByDictCodes((List)Lists.newArrayList((Object[])split));
            }
            for (VisitPlanRateClientInfo visitPlanLineRangeClientInfoVo : visitPlanLineRangeClientInfoVos) {
                Date firstVisitDate = visitPlanLineRangeClientInfoVo.getFirstVisitDate();
                Integer visitRate = visitPlanLineRangeClientInfoVo.getVisitRate();
                int dayDiffer = this.getDayDiffer(firstVisitDate, range.getLoopsEndDate());
                int count = dayDiffer / visitRate;
                for (int i = 0; i < count; ++i) {
                    Date visitDate = DateUtils.addDays((Date)firstVisitDate, (int)(i * visitRate));
                    String week = weekSdf.format(visitDate);
                    if (weekValues.contains(week)) continue;
                    VisitPlanDetailModel visitPlanDetailModel = (VisitPlanDetailModel)this.nebulaToolkitService.copyObjectByBlankList((Object)visitPlanLineRangeClientInfoVo, VisitPlanDetailModel.class, HashSet.class, ArrayList.class, new String[0]);
                    visitPlanDetailModel.setVisitPlanCode(range.getVisitPlanCode());
                    visitPlanDetailModel.setVisitStatus(VisitStatusEnum.NOT_VISIT.getDictCode());
                    visitPlanDetailModel.setVisitDate(visitDate);
                    visitPlanDetailModels.add(visitPlanDetailModel);
                }
            }
        }
        return visitPlanDetailModels;
    }

    @Transactional
    public void onCreate(Map<String, List<String>> map) {
        List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
        if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
            this.visitPlanDetailVoService.createBatch(visitPlanDetailModels);
        }
    }

    @Transactional
    public void onUpdate(Map<String, List<String>> map) {
        List<VisitPlanDetailModel> visitPlanDetailModels = this.onRequestVisitDetailDto(map);
        if (!CollectionUtils.isEmpty(visitPlanDetailModels)) {
            this.visitPlanDetailVoService.updateBatch(visitPlanDetailModels);
        }
    }

    private int getDayDiffer(Date startDate, Date endDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        long startDateTime = 0L;
        long endDateTime = 0L;
        try {
            startDateTime = dateFormat.parse(dateFormat.format(startDate)).getTime();
            endDateTime = dateFormat.parse(dateFormat.format(endDate)).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return (int)((endDateTime - startDateTime) / 86400000L) + 1;
    }
}

