package com.biz.crm.sfa.business.visit.plan.rate.sdk.vo;

import com.biz.crm.sfa.business.visit.plan.sdk.abstracts.VisitPlanRouteRangeAbstract;
import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitWeekTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 网点拜访信息vo
 *
 * @author songjingen
 */
@Data
public class VisitPlanRateRouteRangeVo extends VisitPlanRouteRangeAbstract {
  private static final long serialVersionUID = -6248873806113602955L;
  /**
   * 循环开始日期
   */
  @ApiModelProperty("循环开始日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date loopsStartDate;

  /**
   * 循环结束日期
   */
  @ApiModelProperty("循环结束日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date loopsEndDate;

  /**
   * 排除星期类型集合字符串（星期一、星期二、星期三、星期四、星期五、星期六、星期日）
   * {@link VisitWeekTypeEnum#getDictCode()}
   */
  @ApiModelProperty("排除星期类型集合字符串,例如： Mon,Sun")
  private String notWeekSet;

  /**
   * 关联网点集合
   */
  @ApiModelProperty("关联网点集合")
  private List<VisitPlanRateClientInfoVo> clientInfos;

}
