package com.biz.crm.sfa.business.visit.plan.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 拜访计划明细查询dto
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitPlanDetailQueryDto", description = "拜访计划明细查询dto")
public class VisitPlanDetailQueryDto {

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员职位编码
   */
  @ApiModelProperty("人员职位编码")
  private String visitPostCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String clientCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String clientName;

  /**
   * 客户类型
   * {@link ClientTypeEnum#getDictCode()}
   */
  @ApiModelProperty("客户类型")
  private String clientType;

  /**
   * 协访状态
   */
  @ApiModelProperty("协访状态")
  private String visitStatus;

  /**
   * 拜访日期
   */
  @ApiModelProperty("拜访日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date visitDate;

  /**
   * 拜访日期(年月查询)
   */
  @ApiModelProperty("拜访日期")
  @DateTimeFormat(pattern = "yyyy-MM")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
  private Date visitDateMonth;

  /**
   * 拜访日期(年月查询)
   */
  @ApiModelProperty(value = "拜访日期", hidden = true)
  private String visitDateMonthStr;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitStartDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date visitEndDate;


}
