package com.biz.crm.sfa.business.visit.plan.sdk.dto;

import com.biz.crm.sfa.business.visit.plan.sdk.enums.VisitPlanTypeEnum;
import com.biz.crm.sfa.business.visit.plan.sdk.register.VisitPlanRouteRegister;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 拜访计划查询dto
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "VisitPlanQueryDto", description = "拜访计划查询dto")
public class VisitPlanQueryDto {

  private static final long serialVersionUID = 7022214277071025864L;

  /**
   * 租户编码
   */
  @ApiModelProperty("租户编码")
  private String tenantCode;

  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  private String visitPlanCode;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String visitRealName;

  /**
   * 人员账号
   */
  @ApiModelProperty("人员账号")
  private String visitUserName;

  /**
   * 拜访类型  临时拜访-计划外，计划拜访-计划内
   * <p>
   * {@link VisitPlanTypeEnum#getDictCode()}
   */
  @ApiModelProperty("拜访计划类型")
  private String visitPlanType;

  /**
   * 人员职位名称
   */
  @ApiModelProperty("人员职位名称")
  private String visitPostName;

  /**
   * 启用状态
   */
  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 循环开始日期
   */
  @ApiModelProperty("循环开始日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date startDate;

  /**
   * 循环结束日期
   */
  @ApiModelProperty("循环结束日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date endDate;

  /**
   * 维度类型 维度类型（线路组、网点、频率）
   * <p>
   * {@link VisitPlanRouteRegister#getKey()}
   */
  @ApiModelProperty("拜访维度类型：线路组-line、网点-outlets、频率-rate")
  private String visitRouteType;

}
