package com.biz.crm.sfa.business.visit.plan.sdk.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author songjingen
 * @description: 拜访计划类型枚举
 */
public enum VisitPlanTypeEnum {

  PLAN("plan", "plan", "计划拜访", "1"),
  TEMPORARY("temporary", "temporary", "临时拜访", "2"),
  ;

  /**
   * 字典key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  VisitPlanTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 VisitPlanTypeEnum
   *
   * @param key
   * @return
   */
  public static VisitPlanTypeEnum getByKey(String key) {
    return Arrays.stream(VisitPlanTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCode获取 VisitPlanTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static VisitPlanTypeEnum getByDictCode(String dictCode) {
    return Arrays.stream(VisitPlanTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), dictCode)).findFirst().orElse(null);
  }

}
