package com.biz.crm.sfa.business.visit.plan.sdk.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author songjingen
 * @description: 星期类型枚举
 */
public enum VisitWeekTypeEnum {

  MON("一", "Mon", "星期一", "1"),
  TUE("二", "Tue", "星期二", "2"),
  WED("三", "Wed", "星期三", "3"),
  THUR("四", "Thur", "星期四", "4"),
  FRI("五", "Fri", "星期五", "5"),
  SAT("六", "Sat", "星期六", "6"),
  SUN("日", "Sun", "星期日", "7"),
  ;

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  VisitWeekTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 WeekTypeEnum
   *
   * @param key
   * @return
   */
  public static VisitWeekTypeEnum getByKey(String key) {
    return Arrays.stream(VisitWeekTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key)).findFirst().orElse(null);
  }

  /**
   * 通过dictCodes获取 values
   *
   * @param dictCodes
   * @return
   */
  public static List<String> getValuesByDictCodes(List<String> dictCodes) {
    return Arrays.stream(VisitWeekTypeEnum.values()).filter(item -> dictCodes.contains(item.getDictCode())).map(VisitWeekTypeEnum::getValue).collect(Collectors.toList());
  }

}
