package com.biz.crm.sfa.business.visit.plan.sdk.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Entity;
import java.util.Date;

/**
 * 拜访维度返回基础公共信息
 *
 * @author songjingen
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@ApiModel(value = "VisitPlanRouteRangeVo", description = "拜访维度返回基础公共信息")
public class VisitPlanRouteRangeModel {

  /**
   * 拜访计划编码
   */
  @ApiModelProperty("拜访计划编码")
  private String visitPlanCode;

  /**
   * 拜访开始时间
   */
  @ApiModelProperty("拜访开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date startDate;

  /**
   * 拜访结束时间
   */
  @ApiModelProperty("拜访结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date endDate;

}
